%%SAMPLERFRONT_BINDING%% var samplerFront : sampler;
%%TEXTUREFRONT_BINDING%% var textureFront : texture_2d<f32>;

struct ShaderParams {
    x0: f32,
    y0: f32,
    x1: f32,
    y1: f32,
    right: f32
};
%%SHADERPARAMS_BINDING%% var<uniform> shaderParams : ShaderParams;
%%C3PARAMS_STRUCT%%
%%C3_UTILITY_FUNCTIONS%%
%%FRAGMENTINPUT_STRUCT%%
%%FRAGMENTOUTPUT_STRUCT%%
@fragment
fn main(input : FragmentInput) -> FragmentOutput
{
    let tex = (input.fragUV - c3Params.srcOriginStart) / (c3Params.srcOriginEnd - c3Params.srcOriginStart);
    var value = (shaderParams.x1 - shaderParams.x0)*(tex.y - shaderParams.y0) - (tex.x - shaderParams.x0)*(shaderParams.y1 - shaderParams.y0);
    value = select(-value, value, shaderParams.right > 0.0);
    var output : FragmentOutput;
    var front : vec4<f32> = c3_unpremultiply(textureSample(textureFront, samplerFront, input.fragUV));
    if (value <= 0.0) {
        output.color = front;
    } else {
        output.color = vec4<f32>(0.0);
    }
    return output;
}
