#version 300 es
precision highp float;

//The current foreground texture co-ordinate
in mediump vec2 vTex;
// Output color
out lowp vec4 outColor;
//The foreground texture sampler, to be sampled at vTex
uniform lowp sampler2D samplerFront;

uniform lowp float x0;
uniform lowp float y0;
uniform lowp float x1;
uniform lowp float y1;
uniform lowp float right;

uniform mediump vec2 srcOriginStart;
uniform mediump vec2 srcOriginEnd;

void main(void)
{
  //The current foreground texture co-ordinate
	mediump vec2 tex = (vTex-srcOriginStart)/(srcOriginEnd-srcOriginStart);
	lowp float value = (x1 - x0)*(tex.y - y0) - (tex.x - x0)*(y1 - y0);
	value = right > 0.0 ? value : -value;
	if (value <= 0.0)
	{
		outColor = texture(samplerFront, vTex);
	} else {
		outColor = vec4(0.0);
	}
}