uniform lowp float x0;
uniform lowp float y0;
uniform lowp float x1;
uniform lowp float y1;
uniform lowp float right;

/////////////////////////////////////////////////////////
// slice

//The current foreground texture co-ordinate
varying mediump vec2 vTex;
//The foreground texture sampler, to be sampled at vTex
uniform lowp sampler2D samplerFront;
//The current foreground rectangle being rendered
uniform mediump vec2 srcStart;
uniform mediump vec2 srcEnd;
//The current foreground source rectangle being rendered
uniform mediump vec2 srcOriginStart;
uniform mediump vec2 srcOriginEnd;
//The current foreground source rectangle being rendered, in layout 
uniform mediump vec2 layoutStart;
uniform mediump vec2 layoutEnd;
//The background texture sampler used for background - blending effects
uniform lowp sampler2D samplerBack;
//The current background rectangle being rendered to, in texture co-ordinates, for background-blending effects
uniform mediump vec2 destStart;
uniform mediump vec2 destEnd;
//The time in seconds since the runtime started. This can be used for animated effects
uniform mediump float seconds;
//The size of a texel in the foreground texture in texture co-ordinates
uniform mediump vec2 pixelSize;
//The current layer scale as a factor (i.e. 1 is unscaled)
uniform mediump float layerScale;
//The current layer angle in radians.
uniform mediump float layerAngle;

void main(void)
{
  //The current foreground texture co-ordinate
	mediump vec2 tex = (vTex-srcOriginStart)/(srcOriginEnd-srcOriginStart);
	lowp float value = (x1 - x0)*(tex.y - y0) - (tex.x - x0)*(y1 - y0);
	value = right > 0.0 ? value : -value;
	if (value <= 0.0)
	{
		gl_FragColor = texture2D(samplerFront, vTex);
	} else {
		gl_FragColor = vec4(0.0);
	}
}
