%%SAMPLERFRONT_BINDING%% var samplerFront : sampler;
%%TEXTUREFRONT_BINDING%% var textureFront : texture_2d<f32>;

%%SAMPLERBACK_BINDING%% var samplerBack : sampler;
%%TEXTUREBACK_BINDING%% var textureBack : texture_2d<f32>;

struct ShaderParams {
	screenXResolution: f32,
	screenYResolution: f32,
	normalScaleX: f32,
	normalScaleY: f32,
	normalAngle : f32,
	lightMaxID: f32,
	ambientColor : vec3<f32>,
	ambientIntensity : f32,
	light1Intensity : f32,
	light1PosX : f32,
	light1PosY : f32,
	light1PosZ: f32,
	light1Color : vec3<f32>,
	light1Clamp : f32,
	light1LinearFalloff : f32,
	light1QuadraticFalloff : f32,
	light2Intensity : f32,
	light2PosX : f32,
	light2PosY : f32,
	light2PosZ : f32,
	light2Color : vec3<f32>,
	light2Clamp : f32,
	light2LinearFalloff : f32,
	light2QuadraticFalloff : f32,
	light3Intensity : f32,
	light3PosX : f32,
	light3PosY : f32,
	light3PosZ : f32,
	light3Color : vec3<f32>,
	light3Clamp : f32,
	light3LinearFalloff : f32,
	light3QuadraticFalloff : f32,
	light4Intensity : f32,
	light4PosX : f32,
	light4PosY : f32,
	light4PosZ : f32,
	light4Color : vec3<f32>,
	light4Clamp : f32,
	light4LinearFalloff : f32,
	light4QuadraticFalloff : f32,
	light5Intensity : f32,
	light5PosX : f32,
	light5PosY : f32,
	light5PosZ : f32,
	light5Color : vec3<f32>,
	light5Clamp : f32,
	light5LinearFalloff : f32,
	light5QuadraticFalloff : f32,
	light6Intensity : f32,
	light6PosX : f32,
	light6PosY : f32,
	light6PosZ : f32,
	light6Color : vec3<f32>,
	light6Clamp : f32,
	light6LinearFalloff : f32,
	light6QuadraticFalloff : f32,
	light7Intensity : f32,
	light7PosX : f32,
	light7PosY : f32,
	light7PosZ : f32,
	light7Color : vec3<f32>,
	light7Clamp : f32,
	light7LinearFalloff : f32,
	light7QuadraticFalloff : f32,
	light8Intensity : f32,
	light8PosX : f32,
	light8PosY : f32,
	light8PosZ : f32,
	light8Color : vec3<f32>,
	light8Clamp : f32,
	light8LinearFalloff : f32,
	light8QuadraticFalloff : f32,
	light9Intensity : f32,
	light9PosX : f32,
	light9PosY : f32,
	light9PosZ : f32,
	light9Color : vec3<f32>,
	light9Clamp : f32,
	light9LinearFalloff : f32,
	light9QuadraticFalloff : f32,
	light10Intensity : f32,
	light10PosX : f32,
	light10PosY : f32,
	light10PosZ : f32,
	light10Color : vec3<f32>,
	light10Clamp : f32,
	light10LinearFalloff : f32,
	light10QuadraticFalloff : f32,
	light11Intensity : f32,
	light11PosX : f32,
	light11PosY : f32,
	light11PosZ : f32,
	light11Color : vec3<f32>,
	light11Clamp : f32,
	light11LinearFalloff : f32,
	light11QuadraticFalloff : f32,
	light12Intensity : f32,
	light12PosX : f32,
	light12PosY : f32,
	light12PosZ : f32,
	light12Color : vec3<f32>,
	light12Clamp : f32,
	light12LinearFalloff : f32,
	light12QuadraticFalloff : f32,
	light13Intensity : f32,
	light13PosX : f32,
	light13PosY : f32,
	light13PosZ : f32,
	light13Color : vec3<f32>,
	light13Clamp : f32,
	light13LinearFalloff : f32,
	light13QuadraticFalloff : f32,
	light14Intensity : f32,
	light14PosX : f32,
	light14PosY : f32,
	light14PosZ : f32,
	light14Color : vec3<f32>,
	light14Clamp : f32,
	light14LinearFalloff : f32,
	light14QuadraticFalloff : f32,
	light15Intensity : f32,
	light15PosX : f32,
	light15PosY : f32,
	light15PosZ : f32,
	light15Color : vec3<f32>,
	light15Clamp : f32,
	light15LinearFalloff : f32,
	light15QuadraticFalloff : f32,
	light16Intensity : f32,
	light16PosX : f32,
	light16PosY : f32,
	light16PosZ : f32,
	light16Color : vec3<f32>,
	light16Clamp : f32,
	light16LinearFalloff : f32,
	light16QuadraticFalloff : f32,
	light17Intensity : f32,
	light17PosX : f32,
	light17PosY : f32,
	light17PosZ : f32,
	light17Color : vec3<f32>,
	light17Clamp : f32,
	light17LinearFalloff : f32,
	light17QuadraticFalloff : f32,
	light18Intensity : f32,
	light18PosX : f32,
	light18PosY : f32,
	light18PosZ : f32,
	light18Color : vec3<f32>,
	light18Clamp : f32,
	light18LinearFalloff : f32,
	light18QuadraticFalloff : f32,
	light19Intensity : f32,
	light19PosX : f32,
	light19PosY : f32,
	light19PosZ : f32,
	light19Color : vec3<f32>,
	light19Clamp : f32,
	light19LinearFalloff : f32,
	light19QuadraticFalloff : f32,
	light20Intensity : f32,
	light20PosX : f32,
	light20PosY : f32,
	light20PosZ : f32,
	light20Color : vec3<f32>,
	light20Clamp : f32,
	light20LinearFalloff : f32,
	light20QuadraticFalloff : f32,
	light21Intensity : f32,
	light21PosX : f32,
	light21PosY : f32,
	light21PosZ : f32,
	light21Color : vec3<f32>,
	light21Clamp : f32,
	light21LinearFalloff : f32,
	light21QuadraticFalloff : f32,
	light22Intensity : f32,
	light22PosX : f32,
	light22PosY : f32,
	light22PosZ : f32,
	light22Color : vec3<f32>,
	light22Clamp : f32,
	light22LinearFalloff : f32,
	light22QuadraticFalloff : f32,
	light23Intensity : f32,
	light23PosX : f32,
	light23PosY : f32,
	light23PosZ : f32,
	light23Color : vec3<f32>,
	light23Clamp : f32,
	light23LinearFalloff : f32,
	light23QuadraticFalloff : f32,
	light24Intensity : f32,
	light24PosX : f32,
	light24PosY : f32,
	light24PosZ : f32,
	light24Color : vec3<f32>,
	light24Clamp : f32,
	light24LinearFalloff : f32,
	light24QuadraticFalloff : f32,
	light25Intensity : f32,
	light25PosX : f32,
	light25PosY : f32,
	light25PosZ : f32,
	light25Color : vec3<f32>,
	light25Clamp : f32,
	light25LinearFalloff : f32,
	light25QuadraticFalloff : f32,
	light26Intensity : f32,
	light26PosX : f32,
	light26PosY : f32,
	light26PosZ : f32,
	light26Color : vec3<f32>,
	light26Clamp : f32,
	light26LinearFalloff : f32,
	light26QuadraticFalloff : f32,
	light27Intensity : f32,
	light27PosX : f32,
	light27PosY : f32,
	light27PosZ : f32,
	light27Color : vec3<f32>,
	light27Clamp : f32,
	light27LinearFalloff : f32,
	light27QuadraticFalloff : f32,
	light28Intensity : f32,
	light28PosX : f32,
	light28PosY : f32,
	light28PosZ : f32,
	light28Color : vec3<f32>,
	light28Clamp : f32,
	light28LinearFalloff : f32,
	light28QuadraticFalloff : f32,
	light29Intensity : f32,
	light29PosX : f32,
	light29PosY : f32,
	light29PosZ : f32,
	light29Color : vec3<f32>,
	light29Clamp : f32,
	light29LinearFalloff : f32,
	light29QuadraticFalloff : f32,
	light30Intensity : f32,
	light30PosX : f32,
	light30PosY : f32,
	light30PosZ : f32,
	light30Color : vec3<f32>,
	light30Clamp : f32,
	light30LinearFalloff : f32,
	light30QuadraticFalloff : f32,
	light31Intensity : f32,
	light31PosX : f32,
	light31PosY : f32,
	light31PosZ : f32,
	light31Color : vec3<f32>,
	light31Clamp : f32,
	light31LinearFalloff : f32,
	light31QuadraticFalloff : f32,
	light32Intensity : f32,
	light32PosX : f32,
	light32PosY : f32,
	light32PosZ : f32,
	light32Color : vec3<f32>,
	light32Clamp : f32,
	light32LinearFalloff : f32,
	light32QuadraticFalloff : f32,
};

%%SHADERPARAMS_BINDING%% var<uniform> shaderParams : ShaderParams;

%%FRAGMENTINPUT_STRUCT%%
%%FRAGMENTOUTPUT_STRUCT%%

%%C3_UTILITY_FUNCTIONS%%
%%C3PARAMS_STRUCT%%

const PI180: f32 = 0.01745329;

fn rotate(v: vec2<f32>, a: f32) -> vec2<f32> {
	let s: f32 = sin(a);
	let c: f32 = cos(a);
	let m: mat2x2<f32> = mat2x2<f32>(c, s, -s, c);
	return m * v;
} 

@fragment
fn main(input : FragmentInput) -> FragmentOutput {

	let lightIntensity : array<f32,32> = array<f32,32>(
		shaderParams.light1Intensity, 
		shaderParams.light2Intensity, 
		shaderParams.light3Intensity, 
		shaderParams.light4Intensity, 
		shaderParams.light5Intensity, 
		shaderParams.light6Intensity, 
		shaderParams.light7Intensity, 
		shaderParams.light8Intensity, 
		shaderParams.light9Intensity, 
		shaderParams.light10Intensity, 
		shaderParams.light11Intensity, 
		shaderParams.light12Intensity, 
		shaderParams.light13Intensity, 
		shaderParams.light14Intensity, 
		shaderParams.light15Intensity, 
		shaderParams.light16Intensity, 
		shaderParams.light17Intensity, 
		shaderParams.light18Intensity, 
		shaderParams.light19Intensity, 
		shaderParams.light20Intensity, 
		shaderParams.light21Intensity, 
		shaderParams.light22Intensity, 
		shaderParams.light23Intensity, 
		shaderParams.light24Intensity, 
		shaderParams.light25Intensity, 
		shaderParams.light26Intensity, 
		shaderParams.light27Intensity, 
		shaderParams.light28Intensity, 
		shaderParams.light29Intensity, 
		shaderParams.light30Intensity, 
		shaderParams.light31Intensity, 
		shaderParams.light32Intensity
	);

	let lightClamp : array<f32,32> = array<f32,32>(
		shaderParams.light1Clamp * 10.0,
		shaderParams.light2Clamp * 10.0,
		shaderParams.light3Clamp * 10.0,
		shaderParams.light4Clamp * 10.0,
		shaderParams.light5Clamp * 10.0,
		shaderParams.light6Clamp * 10.0,
		shaderParams.light7Clamp * 10.0,
		shaderParams.light8Clamp * 10.0,
		shaderParams.light9Clamp * 10.0,
		shaderParams.light10Clamp * 10.0,
		shaderParams.light11Clamp * 10.0,
		shaderParams.light12Clamp * 10.0,
		shaderParams.light13Clamp * 10.0,
		shaderParams.light14Clamp * 10.0,
		shaderParams.light15Clamp * 10.0,
		shaderParams.light16Clamp * 10.0,
		shaderParams.light17Clamp * 10.0,
		shaderParams.light18Clamp * 10.0,
		shaderParams.light19Clamp * 10.0,
		shaderParams.light20Clamp * 10.0,
		shaderParams.light21Clamp * 10.0,
		shaderParams.light22Clamp * 10.0,
		shaderParams.light23Clamp * 10.0,
		shaderParams.light24Clamp * 10.0,
		shaderParams.light25Clamp * 10.0,
		shaderParams.light26Clamp * 10.0,
		shaderParams.light27Clamp * 10.0,
		shaderParams.light28Clamp * 10.0,
		shaderParams.light29Clamp * 10.0,
		shaderParams.light30Clamp * 10.0,
		shaderParams.light31Clamp * 10.0,
		shaderParams.light32Clamp * 10.0
	);

	let lightPos : array<vec3<f32>,32> = array<vec3<f32>,32>(
		vec3<f32>(shaderParams.light1PosX, shaderParams.light1PosY, shaderParams.light1PosZ), 
		vec3<f32>(shaderParams.light2PosX, shaderParams.light2PosY, shaderParams.light2PosZ), 
		vec3<f32>(shaderParams.light3PosX, shaderParams.light3PosY, shaderParams.light3PosZ), 
		vec3<f32>(shaderParams.light4PosX, shaderParams.light4PosY, shaderParams.light4PosZ), 
		vec3<f32>(shaderParams.light5PosX, shaderParams.light5PosY, shaderParams.light5PosZ), 
		vec3<f32>(shaderParams.light6PosX, shaderParams.light6PosY, shaderParams.light6PosZ), 
		vec3<f32>(shaderParams.light7PosX, shaderParams.light7PosY, shaderParams.light7PosZ), 
		vec3<f32>(shaderParams.light8PosX, shaderParams.light8PosY, shaderParams.light8PosZ), 
		vec3<f32>(shaderParams.light9PosX, shaderParams.light9PosY, shaderParams.light9PosZ), 
		vec3<f32>(shaderParams.light10PosX, shaderParams.light10PosY, shaderParams.light10PosZ), 
		vec3<f32>(shaderParams.light11PosX, shaderParams.light11PosY, shaderParams.light11PosZ), 
		vec3<f32>(shaderParams.light12PosX, shaderParams.light12PosY, shaderParams.light12PosZ), 
		vec3<f32>(shaderParams.light13PosX, shaderParams.light13PosY, shaderParams.light13PosZ), 
		vec3<f32>(shaderParams.light14PosX, shaderParams.light14PosY, shaderParams.light14PosZ), 
		vec3<f32>(shaderParams.light15PosX, shaderParams.light15PosY, shaderParams.light15PosZ), 
		vec3<f32>(shaderParams.light16PosX, shaderParams.light16PosY, shaderParams.light16PosZ), 
		vec3<f32>(shaderParams.light17PosX, shaderParams.light17PosY, shaderParams.light17PosZ), 
		vec3<f32>(shaderParams.light18PosX, shaderParams.light18PosY, shaderParams.light18PosZ), 
		vec3<f32>(shaderParams.light19PosX, shaderParams.light19PosY, shaderParams.light19PosZ), 
		vec3<f32>(shaderParams.light20PosX, shaderParams.light20PosY, shaderParams.light20PosZ), 
		vec3<f32>(shaderParams.light21PosX, shaderParams.light21PosY, shaderParams.light21PosZ), 
		vec3<f32>(shaderParams.light22PosX, shaderParams.light22PosY, shaderParams.light22PosZ), 
		vec3<f32>(shaderParams.light23PosX, shaderParams.light23PosY, shaderParams.light23PosZ), 
		vec3<f32>(shaderParams.light24PosX, shaderParams.light24PosY, shaderParams.light24PosZ), 
		vec3<f32>(shaderParams.light25PosX, shaderParams.light25PosY, shaderParams.light25PosZ), 
		vec3<f32>(shaderParams.light26PosX, shaderParams.light26PosY, shaderParams.light26PosZ), 
		vec3<f32>(shaderParams.light27PosX, shaderParams.light27PosY, shaderParams.light27PosZ), 
		vec3<f32>(shaderParams.light28PosX, shaderParams.light28PosY, shaderParams.light28PosZ), 
		vec3<f32>(shaderParams.light29PosX, shaderParams.light29PosY, shaderParams.light29PosZ), 
		vec3<f32>(shaderParams.light30PosX, shaderParams.light30PosY, shaderParams.light30PosZ), 
		vec3<f32>(shaderParams.light31PosX, shaderParams.light31PosY, shaderParams.light31PosZ), 
		vec3<f32>(shaderParams.light32PosX, shaderParams.light32PosY, shaderParams.light32PosZ)
	);

	let lightColor : array<vec3<f32>,32> = array<vec3<f32>,32>(
		vec3<f32>(shaderParams.light1Color), 
		vec3<f32>(shaderParams.light2Color), 
		vec3<f32>(shaderParams.light3Color), 
		vec3<f32>(shaderParams.light4Color), 
		vec3<f32>(shaderParams.light5Color), 
		vec3<f32>(shaderParams.light6Color), 
		vec3<f32>(shaderParams.light7Color), 
		vec3<f32>(shaderParams.light8Color), 
		vec3<f32>(shaderParams.light9Color), 
		vec3<f32>(shaderParams.light10Color), 
		vec3<f32>(shaderParams.light11Color), 
		vec3<f32>(shaderParams.light12Color), 
		vec3<f32>(shaderParams.light13Color), 
		vec3<f32>(shaderParams.light14Color), 
		vec3<f32>(shaderParams.light15Color), 
		vec3<f32>(shaderParams.light16Color), 
		vec3<f32>(shaderParams.light17Color), 
		vec3<f32>(shaderParams.light18Color), 
		vec3<f32>(shaderParams.light19Color), 
		vec3<f32>(shaderParams.light20Color), 
		vec3<f32>(shaderParams.light21Color), 
		vec3<f32>(shaderParams.light22Color), 
		vec3<f32>(shaderParams.light23Color), 
		vec3<f32>(shaderParams.light24Color), 
		vec3<f32>(shaderParams.light25Color), 
		vec3<f32>(shaderParams.light26Color), 
		vec3<f32>(shaderParams.light27Color), 
		vec3<f32>(shaderParams.light28Color), 
		vec3<f32>(shaderParams.light29Color), 
		vec3<f32>(shaderParams.light30Color), 
		vec3<f32>(shaderParams.light31Color), 
		vec3<f32>(shaderParams.light32Color)
	);

	let falloff : array<vec2<f32>,32> = array<vec2<f32>,32>(
		vec2<f32>(shaderParams.light1LinearFalloff, shaderParams.light1QuadraticFalloff), 
		vec2<f32>(shaderParams.light2LinearFalloff, shaderParams.light2QuadraticFalloff), 
		vec2<f32>(shaderParams.light3LinearFalloff, shaderParams.light3QuadraticFalloff), 
		vec2<f32>(shaderParams.light4LinearFalloff, shaderParams.light4QuadraticFalloff), 
		vec2<f32>(shaderParams.light5LinearFalloff, shaderParams.light5QuadraticFalloff), 
		vec2<f32>(shaderParams.light6LinearFalloff, shaderParams.light6QuadraticFalloff), 
		vec2<f32>(shaderParams.light7LinearFalloff, shaderParams.light7QuadraticFalloff), 
		vec2<f32>(shaderParams.light8LinearFalloff, shaderParams.light8QuadraticFalloff), 
		vec2<f32>(shaderParams.light9LinearFalloff, shaderParams.light9QuadraticFalloff), 
		vec2<f32>(shaderParams.light10LinearFalloff, shaderParams.light10QuadraticFalloff), 
		vec2<f32>(shaderParams.light11LinearFalloff, shaderParams.light11QuadraticFalloff), 
		vec2<f32>(shaderParams.light12LinearFalloff, shaderParams.light12QuadraticFalloff), 
		vec2<f32>(shaderParams.light13LinearFalloff, shaderParams.light13QuadraticFalloff), 
		vec2<f32>(shaderParams.light14LinearFalloff, shaderParams.light14QuadraticFalloff), 
		vec2<f32>(shaderParams.light15LinearFalloff, shaderParams.light15QuadraticFalloff), 
		vec2<f32>(shaderParams.light16LinearFalloff, shaderParams.light16QuadraticFalloff), 
		vec2<f32>(shaderParams.light17LinearFalloff, shaderParams.light17QuadraticFalloff), 
		vec2<f32>(shaderParams.light18LinearFalloff, shaderParams.light18QuadraticFalloff), 
		vec2<f32>(shaderParams.light19LinearFalloff, shaderParams.light19QuadraticFalloff), 
		vec2<f32>(shaderParams.light20LinearFalloff, shaderParams.light20QuadraticFalloff), 
		vec2<f32>(shaderParams.light21LinearFalloff, shaderParams.light21QuadraticFalloff), 
		vec2<f32>(shaderParams.light22LinearFalloff, shaderParams.light22QuadraticFalloff), 
		vec2<f32>(shaderParams.light23LinearFalloff, shaderParams.light23QuadraticFalloff), 
		vec2<f32>(shaderParams.light24LinearFalloff, shaderParams.light24QuadraticFalloff), 
		vec2<f32>(shaderParams.light25LinearFalloff, shaderParams.light25QuadraticFalloff), 
		vec2<f32>(shaderParams.light26LinearFalloff, shaderParams.light26QuadraticFalloff), 
		vec2<f32>(shaderParams.light27LinearFalloff, shaderParams.light27QuadraticFalloff), 
		vec2<f32>(shaderParams.light28LinearFalloff, shaderParams.light28QuadraticFalloff), 
		vec2<f32>(shaderParams.light29LinearFalloff, shaderParams.light29QuadraticFalloff), 
		vec2<f32>(shaderParams.light30LinearFalloff, shaderParams.light30QuadraticFalloff), 
		vec2<f32>(shaderParams.light31LinearFalloff, shaderParams.light31QuadraticFalloff), 
		vec2<f32>(shaderParams.light32LinearFalloff, shaderParams.light32QuadraticFalloff)
	);

	let texSize : vec2<u32> = textureDimensions(textureBack);
	var iResolution : vec2<f32> = vec2<f32>(f32(texSize.x), f32(texSize.y));
	iResolution = round(iResolution * c3Params.devicePixelRatio);

	let front : vec4<f32> = textureSample(textureFront, samplerFront, input.fragUV);
	let back : vec4<f32> = textureSample(textureBack, samplerBack, c3_getBackUV(input.fragPos.xy, textureBack));
	var normal : vec3<f32> = normalize(front.rgb * 2.0 - 1.0);

	normal = vec3<f32>(normal.x / shaderParams.normalScaleX, normal.y / shaderParams.normalScaleY, normal.z);
	normal = vec3<f32>(rotate(normal.xy, -shaderParams.normalAngle * PI180), normal.z);

	let fragCoord: vec2<f32> = input.fragPos.xy / iResolution;
	let aspectRatio: f32 = iResolution.x / iResolution.y;
	let lightMax: i32 = i32(clamp(shaderParams.lightMaxID, 0.0, 32.0));
	let ambient: vec3<f32> = shaderParams.ambientColor * shaderParams.ambientIntensity * 2.0;
	var sum : vec3<f32> = vec3<f32>(back.rgb * ambient);

	for (var i : i32 = 0; i < 32; i++) {
		if (i >= lightMax) { break; }
		var light : vec3<f32> = vec3<f32>(lightPos[i].xy - fragCoord, lightPos[i].z);
		light.x *= aspectRatio;
		var D : f32 = length(light);
		D = mix(D, 1000.0, step(lightClamp[i], D));
		var L : vec3<f32> = normalize(light);
		L.y = 0.0 - L.y;
		let diffuse : vec3<f32> = lightColor[i] * lightIntensity[i] * max(dot(normal,L), 0.0);
		let attenuation : f32 = clamp(1.0 - (falloff[i].x*D + falloff[i].y*D*D),0.0,1.0);
		let intensity : vec3<f32> = diffuse * attenuation;
		let finalColor : vec3<f32> = back.rgb * intensity;
		sum += finalColor * lightIntensity[i];
	}
	var output : FragmentOutput;
	output.color = vec4<f32>(sum, back.a) * front.a;
	return output;
}