"use strict";
{
    C3.Plugins.mcAutoTiling.Instance = class mcAutoTilingInstance extends C3.SDKInstanceBase
    {
        constructor(inst, properties)
        {
            super(inst);
            this.atArray = new Array();
            this.atArrayMask = new Array();
            this.atWidth = 0;
            this.atHeight = 0;
            this.atList = new Array;

            for (var i = 0; i < 256; i++)
            {
                this.atList[i] = -1;
            }

            this.atList[2] = 1;
            this.atList[8] = 2;
            this.atList[10] = 3;
            this.atList[11] = 4;
            this.atList[16] = 5;
            this.atList[18] = 6;
            this.atList[22] = 7;
            this.atList[24] = 8;
            this.atList[26] = 9;
            this.atList[27] = 10;
            this.atList[30] = 11;
            this.atList[31] = 12;
            this.atList[64] = 13;
            this.atList[66] = 14;
            this.atList[72] = 15;
            this.atList[74] = 16;
            this.atList[75] = 17;
            this.atList[80] = 18;
            this.atList[82] = 19;
            this.atList[86] = 20;
            this.atList[88] = 21;
            this.atList[90] = 22;
            this.atList[91] = 23;
            this.atList[94] = 24;
            this.atList[95] = 25;
            this.atList[104] = 26;
            this.atList[106] = 27;
            this.atList[107] = 28;
            this.atList[120] = 29;
            this.atList[122] = 30;
            this.atList[123] = 31;
            this.atList[126] = 32;
            this.atList[127] = 33;
            this.atList[208] = 34;
            this.atList[210] = 35;
            this.atList[214] = 36;
            this.atList[216] = 37;
            this.atList[218] = 38;
            this.atList[219] = 39;
            this.atList[222] = 40;
            this.atList[223] = 41;
            this.atList[248] = 42;
            this.atList[250] = 43;
            this.atList[251] = 44;
            this.atList[254] = 45;
            this.atList[255] = 46;
            this.atList[0] = 47;


            this.instanceTilemap;

            this.autoupdate = true;
        }

        Release()
        {
            super.Release();
        }

        SaveToJson()
        {
            return {
                // data to be saved for savegames
            };
        }

        LoadFromJson(o)
        {
            // load state for savegames
        }

        setSize(w, h)
        {

            // Array erstellen
            this.atArray = new Array();
            this.atArrayMask = new Array();

            this.atWidth = w;
            this.atHeight = h;

            for (var ii = 0; ii < w; ii++)
            {
                // Array erweitern!
                this.atArray[ii] = new Array();
                this.atArrayMask[ii] = new Array();

                for (var i = 0; i < h; i++)
                {
                    this.atArray[ii][i] = -1;
                    this.atArrayMask[ii][i] = false;
                }
            }

        }

        setSizeAndFill(w, h, id)
        {

            // Array erstellen
            this.atArray = new Array();
            this.atArrayMask = new Array();

            this.atWidth = w;
            this.atHeight = h;

            for (var ii = 0; ii < w; ii++)
            {
                // Array erweitern!
                this.atArray[ii] = new Array();
                this.atArrayMask[ii] = new Array();

                for (var i = 0; i < h; i++)
                {
                    this.atArray[ii][i] = id;
                    this.atArrayMask[ii][i] = true;
                }
            }

        }

        checkTile9(xx, yy, arr, arrmsk, wdt, hgt, list)
        {

            var x = xx;
            var y = yy;
            var current = 0;

            for (var i = 0; i < 8; i++)
            {

                if (x > 0 && x <= wdt - 1 && y > 0 && y <= hgt - 1)
                {

                    if (typeof arrmsk[x] !== 'undefined')
                    {
                        if (typeof arrmsk[x][y] !== 'undefined')
                        {
                            if (arrmsk[x][y] == true)
                            {

                                // Zunächst dieses Tile auf -1 setzen!
                                arr[x][y] = 0;

                                // Oben
                                if (x > 0 && x <= wdt - 1 && y - 1 > 0 && y - 1 <= hgt - 1)
                                {
                                    if (typeof arrmsk[x][y - 1] !== "undefined")
                                    {
                                        if (arrmsk[x][y - 1] == true)
                                        {
                                            arr[x][y] += 2;
                                        }
                                    }
                                }
                                else
                                {
                                    arr[x][y] += 2;
                                }

                                // Rechts
                                if (x + 1 > 0 && x + 1 <= wdt - 1 && y > 0 && y <= hgt - 1)
                                {
                                    if (typeof arrmsk[x + 1][y] !== "undefined")
                                    {
                                        if (arrmsk[x + 1][y] == true)
                                        {
                                            arr[x][y] += 16;
                                        }
                                    }
                                }
                                else
                                {
                                    arr[x][y] += 16;
                                }

                                // Unten
                                if (x > 0 && x <= wdt - 1 && y + 1 > 0 && y + 1 <= hgt - 1)
                                {
                                    if (typeof arrmsk[x][y + 1] !== "undefined")
                                    {
                                        if (arrmsk[x][y + 1] == true)
                                        {
                                            arr[x][y] += 64;
                                        }
                                    }
                                }
                                else
                                {
                                    arr[x][y] += 64;
                                }

                                // Links
                                if (x - 1 > 0 && x - 1 <= wdt - 1 && y > 0 && y <= hgt - 1)
                                {
                                    if (typeof arrmsk[x - 1][y] !== "undefined")
                                    {
                                        if (arrmsk[x - 1][y] == true)
                                        {
                                            arr[x][y] += 8;
                                        }
                                    }

                                }
                                else
                                {
                                    arr[x][y] += 8;
                                }


                                // Oben links
                                if (x - 1 > 0 && x - 1 <= wdt - 1 && y - 1 > 0 && y - 1 <= hgt - 1)
                                {
                                    if (typeof arrmsk[x - 1][y - 1] !== "undefined")
                                    {
                                        if (arrmsk[x - 1][y - 1] == true)
                                        { // Oben Links check...
                                            if ((arrmsk[x][y - 1] == true) && (arrmsk[x - 1][y] == true))
                                            { // .. rechts daneben oder unten drunter
                                                arr[x][y] += 1;
                                            }
                                        }
                                    }
                                }


                                // Oben Rechts
                                if (x + 1 > 0 && x + 1 <= wdt - 1 && y - 1 > 0 && y - 1 <= hgt - 1)
                                {
                                    if (typeof arrmsk[x + 1][y - 1] !== "undefined")
                                    {

                                        if (arrmsk[x + 1][y - 1] == true)
                                        { // Oben Rechts check...
                                            if ((arrmsk[x][y - 1] == true) && (arrmsk[x + 1][y] == true))
                                            { // .. links daneben oder unten drunter
                                                arr[x][y] += 4;
                                            }
                                        }

                                    }
                                }



                                // Unten Rechts
                                if (x + 1 > 0 && x + 1 <= wdt - 1 && y + 1 > 0 && y + 1 <= hgt - 1)
                                {
                                    if (typeof arrmsk[x + 1][y + 1] !== "undefined")
                                    {
                                        if (arrmsk[x + 1][y + 1] == true)
                                        { // Unten Rechts check...
                                            if ((arrmsk[x][y + 1] == true) && (arrmsk[x + 1][y] == true))
                                            { // .. links daneben oder oben drüber
                                                arr[x][y] += 128;
                                            }
                                        }
                                    }

                                }


                                // Unten Links
                                if (x - 1 > 0 && x - 1 <= wdt - 1 && y + 1 > 0 && y + 1 <= hgt - 1)
                                {
                                    if (typeof arrmsk[x - 1][y + 1] !== "undefined")
                                    {
                                        if (arrmsk[x - 1][y + 1] == true)
                                        { // Unten Links check...
                                            if ((arrmsk[x][y + 1] == true) && (arrmsk[x - 1][y] == true))
                                            { // .. rechts daneben oder oben drüber
                                                arr[x][y] += 32;
                                            }
                                        }
                                    }
                                }

                                // Den Wert mit der Liste abgleichen
                                if (arr[x][y] != -1)
                                {
                                    var value = arr[x][y];
                                    var fromlist = list[value];

                                    if (fromlist != -1)
                                    {
                                        arr[x][y] = fromlist;
                                    }
                                }

                            }
                            else
                            {
                                arr[x][y] = -1;
                            }
                        }

                    }
                }

                if (this.autoupdate)
                {
                    if (typeof arr[x] !== "undefined")
                    {
                        if (typeof arr[x][y] !== "undefined")
                        {
                            this.instanceTilemap.SetTileAt(x, y, arr[x][y]);
                        }
                    }
                }

                current++;
                switch (current)
                {
                    case 1:
                        x--;
                        break;
                    case 2:
                        y--;
                        break;
                    case 3:
                        x++;
                        break;
                    case 4:
                        x++;
                        break;
                    case 5:
                        y++;
                        break;
                    case 6:
                        y++;
                        break;
                    case 7:
                        x--;
                        break;
                    case 8:
                        x--;
                        break;

                    case 9:
                        // Ende der Überprüfung
                        i = 8;
                        break;
                }

            }
        }

        tilecorrection()
        {
            // Den Wert mit der Liste abgleichen
            if (arr[x][y] != -1)
            {
                var value = arr[x][y];
                var fromlist = list[value];

                if (fromlist != -1)
                {
                    arr[x][y] = fromlist;
                }
            }
        }

        checkTile(xx, yy, arr, arrmsk, wdt, hgt)
        {

            var x = xx;
            var y = yy;
            var current = 0;

            for (var i = 0; i < 8; i++)
            {

                if (x > 0 && x <= wdt - 1 && y > 0 && y <= hgt - 1)
                {

                    if (typeof arrmsk[x] !== 'undefined')
                    {
                        if (typeof arrmsk[x][y] !== 'undefined')
                        {
                            if (arrmsk[x][y] == true)
                            {

                                // Zunächst dieses Tile auf -1 setzen!
                                arr[x][y] = 0;

                                // Oben
                                if (x > 0 && x <= wdt - 1 && y - 1 > 0 && y - 1 <= hgt - 1)
                                {
                                    if (typeof arrmsk[x][y - 1] !== "undefined")
                                    {
                                        if (arrmsk[x][y - 1] == true)
                                        {
                                            arr[x][y] += 1;
                                        }
                                    }
                                }
                                else
                                {
                                    arr[x][y] += 1;
                                }

                                // Rechts
                                if (x + 1 > 0 && x + 1 <= wdt - 1 && y > 0 && y <= hgt - 1)
                                {
                                    if (typeof arrmsk[x + 1][y] !== "undefined")
                                    {
                                        if (arrmsk[x + 1][y] == true)
                                        {
                                            arr[x][y] += 2;
                                        }
                                    }
                                }
                                else
                                {
                                    arr[x][y] += 2;
                                }

                                // Unten
                                if (x > 0 && x <= wdt - 1 && y + 1 > 0 && y + 1 <= hgt - 1)
                                {
                                    if (typeof arrmsk[x][y + 1] !== "undefined")
                                    {
                                        if (arrmsk[x][y + 1] == true)
                                        {
                                            arr[x][y] += 4;
                                        }
                                    }
                                }
                                else
                                {
                                    arr[x][y] += 4;
                                }

                                // Links
                                if (x - 1 > 0 && x - 1 <= wdt - 1 && y > 0 && y <= hgt - 1)
                                {
                                    if (typeof arrmsk[x - 1][y] !== "undefined")
                                    {
                                        if (arrmsk[x - 1][y] == true)
                                        {
                                            arr[x][y] += 8;
                                        }
                                    }

                                }
                                else
                                {
                                    arr[x][y] += 8;
                                }

                            }
                            else
                            {
                                arr[x][y] = -1;
                            }
                        }
                    }
                }

                if (this.autoupdate)
                {
                    if (typeof arr[x] !== "undefined")
                    {
                        if (typeof arr[x][y] !== "undefined")
                        {
                            this.instanceTilemap.SetTileAt(x, y, arr[x][y]);
                        }
                    }
                }

                current++;
                switch (current)
                {
                    case 1:
                        x--;
                        break;
                    case 2:
                        y--;
                        break;
                    case 3:
                        x++;
                        break;
                    case 4:
                        x++;
                        break;
                    case 5:
                        y++;
                        break;
                    case 6:
                        y++;
                        break;
                    case 7:
                        x--;
                        break;
                    case 8:
                        x--;
                        break;

                    case 9:
                        // Ende der Überprüfung
                        i = 8;
                        break;
                }

            }
        }


        setTile9(x, y)
        {
            if (isNaN(x) || x < 0 || x > this.atWidth - 1)
            {
                return;
            }
            if (isNaN(y) || y < 0 || y > this.atHeight - 1)
            {
                return;
            }

            // Tile der "Maske" auf true setzen
            this.atArrayMask[x][y] = true;

            this.checkTile9(x, y, this.atArray, this.atArrayMask, this.atWidth, this.atHeight, this.atList);
            this.checkTile9(x - 1, y - 1, this.atArray, this.atArrayMask, this.atWidth, this.atHeight, this.atList);
            this.checkTile9(x, y - 1, this.atArray, this.atArrayMask, this.atWidth, this.atHeight, this.atList);
            this.checkTile9(x + 1, y, this.atArray, this.atArrayMask, this.atWidth, this.atHeight, this.atList);
            this.checkTile9(x + 1, y + 1, this.atArray, this.atArrayMask, this.atWidth, this.atHeight, this.atList);
            this.checkTile9(x, y + 1, this.atArray, this.atArrayMask, this.atWidth, this.atHeight, this.atList);
            this.checkTile9(x - 1, y + 1, this.atArray, this.atArrayMask, this.atWidth, this.atHeight, this.atList);
            this.checkTile9(x - 1, y, this.atArray, this.atArrayMask, this.atWidth, this.atHeight, this.atList);
        }

        eraseTile9(x, y)
        {

            if (isNaN(x) || x < 0 || x > this.atWidth - 1)
            {
                return;
            }
            if (isNaN(y) || y < 0 || y > this.atHeight - 1)
            {
                return;
            }

            // Tile der "Maske" auf true setzen
            this.atArrayMask[x][y] = false;

            this.checkTile9(x, y, this.atArray, this.atArrayMask, this.atWidth, this.atHeight, this.atList);
            this.checkTile9(x - 1, y - 1, this.atArray, this.atArrayMask, this.atWidth, this.atHeight, this.atList);
            this.checkTile9(x, y - 1, this.atArray, this.atArrayMask, this.atWidth, this.atHeight, this.atList);
            this.checkTile9(x + 1, y, this.atArray, this.atArrayMask, this.atWidth, this.atHeight, this.atList);
            this.checkTile9(x + 1, y + 1, this.atArray, this.atArrayMask, this.atWidth, this.atHeight, this.atList);
            this.checkTile9(x, y + 1, this.atArray, this.atArrayMask, this.atWidth, this.atHeight, this.atList);
            this.checkTile9(x - 1, y + 1, this.atArray, this.atArrayMask, this.atWidth, this.atHeight, this.atList);
            this.checkTile9(x - 1, y, this.atArray, this.atArrayMask, this.atWidth, this.atHeight, this.atList);
        }

        setTile5(x, y)
        {
            if (isNaN(x) || x < 0 || x > this.atWidth - 1)
            {
                return;
            }
            if (isNaN(y) || y < 0 || y > this.atHeight - 1)
            {
                return;
            }

            // Tile der "Maske" auf true setzen
            this.atArrayMask[x][y] = true;

            this.checkTile(x, y, this.atArray, this.atArrayMask, this.atWidth, this.atHeight);
            this.checkTile(x - 1, y - 1, this.atArray, this.atArrayMask, this.atWidth, this.atHeight);
            this.checkTile(x, y - 1, this.atArray, this.atArrayMask, this.atWidth, this.atHeight);
            this.checkTile(x + 1, y, this.atArray, this.atArrayMask, this.atWidth, this.atHeight);
            this.checkTile(x + 1, y + 1, this.atArray, this.atArrayMask, this.atWidth, this.atHeight);
            this.checkTile(x, y + 1, this.atArray, this.atArrayMask, this.atWidth, this.atHeight);
            this.checkTile(x - 1, y + 1, this.atArray, this.atArrayMask, this.atWidth, this.atHeight);
            this.checkTile(x - 1, y, this.atArray, this.atArrayMask, this.atWidth, this.atHeight);
        }

        eraseTile(x, y)
        {

            if (isNaN(x) || x < 0 || x > this.atWidth - 1)
            {
                return;
            }
            if (isNaN(y) || y < 0 || y > this.atHeight - 1)
            {
                return;
            }

            // Tile der "Maske" auf true setzen
            this.atArrayMask[x][y] = false;

            this.checkTile(x, y, this.atArray, this.atArrayMask, this.atWidth, this.atHeight);
            this.checkTile(x - 1, y - 1, this.atArray, this.atArrayMask, this.atWidth, this.atHeight);
            this.checkTile(x, y - 1, this.atArray, this.atArrayMask, this.atWidth, this.atHeight);
            this.checkTile(x + 1, y, this.atArray, this.atArrayMask, this.atWidth, this.atHeight);
            this.checkTile(x + 1, y + 1, this.atArray, this.atArrayMask, this.atWidth, this.atHeight);
            this.checkTile(x, y + 1, this.atArray, this.atArrayMask, this.atWidth, this.atHeight);
            this.checkTile(x - 1, y + 1, this.atArray, this.atArrayMask, this.atWidth, this.atHeight);
            this.checkTile(x - 1, y, this.atArray, this.atArrayMask, this.atWidth, this.atHeight);
        }

        getTile(x, y)
        {
            if (typeof this.atArray[x][y] !== 'undefined')
            {
                return this.atArray[x][y];
            }
            else
            {
                return -1;
            }
        }

        updateCompleteTilemap()
        {
            if (typeof this.instanceTilemap == "undefined")
            {
                console.warn("Plugin AutoTiling: tilemap not set");
                return;
            }

            if (this.instanceTilemap.GetMapWidth() != this.atArray.length)
            {
                console.warn("Plugin AutoTiling: tilemap width is wrong " + this.instanceTilemap.GetMapWidth() + " / " + this.atArray.length);
                return;
            }
            if (this.instanceTilemap.GetMapHeight() != this.atArray[this.atArray.length - 1].length)
            {
                console.warn("Plugin AutoTiling: tilemap width is wrong " + this.instanceTilemap.GetMapHeight() + " / " + this.atArray[this.atArray.length - 1].length);
                return;
            }

            if (this.atArray.length > 0)
            {
                for (var x = 0; x < this.atArray.length; x++)
                {
                    if (typeof this.atArray[x] !== "undefined")
                    {

                        for (var y = 0; y < this.atArray[x].length; y++)
                        {
                            if (typeof this.atArray[x][y] !== "undefined")
                            {
                                this.instanceTilemap.SetTileAt(x, y, this.atArray[x][y]);
                            }
                        }

                    }
                }
            }

            //this.atWidth = w;
            //this.atHeight = h;
        }

        setTilemap(tm)
        {
            this.instanceTilemap = tm.GetInstances()[0].GetSdkInstance();
        }

        setSizeToTilemapSize()
        {
            if (typeof this.instanceTilemap == "undefined")
            {
                console.warn("Plugin AutoTiling: tilemap not set");
                return;
            }

            this.setSize(this.instanceTilemap.GetMapWidth(), this.instanceTilemap.GetMapHeight());
        }

        setSizeToTilemapSizeAndFill(fill)
        {
            if (typeof this.instanceTilemap == "undefined")
            {
                console.warn("Plugin AutoTiling: tilemap not set");
                return;
            }
            if (typeof fill != "number")
            {
                console.warn("Plugin AutoTiling: fill-type is not a number");
                return;
            }

            this.setSizeAndFill(this.instanceTilemap.GetMapWidth(), this.instanceTilemap.GetMapHeight(), fill);
        }

    };
}