﻿// ECMAScript 5 strict mode
"use strict";

assert2(cr, "cr namespace not created");
assert2(cr.plugins_, "cr.plugins_ not created");

/////////////////////////////////////
// Plugin class
// *** CHANGE THE PLUGIN ID HERE *** - must match the "id" property in edittime.js
//          vvvvvvvv
cr.plugins_.mcAutoTiling = function(runtime)
{
	this.runtime = runtime;
};

(function ()
{
	/////////////////////////////////////
	// *** CHANGE THE PLUGIN ID HERE *** - must match the "id" property in edittime.js
	//                            vvvvvvvv
	var pluginProto = cr.plugins_.mcAutoTiling.prototype;
			
	/////////////////////////////////////
	// Object type class
	pluginProto.Type = function(plugin)
	{
		this.plugin = plugin;
		this.runtime = plugin.runtime;
	};

	var typeProto = pluginProto.Type.prototype;

	// called on startup for each object type
	typeProto.onCreate = function()
	{
	};

	/////////////////////////////////////
	// Instance class
	pluginProto.Instance = function(type)
	{
		this.type = type;
		this.runtime = type.runtime;

		// any other properties you need, e.g...
		// this.myValue = 0;
	};
	

	
	var instanceProto = pluginProto.Instance.prototype;

	// called whenever an instance is created
	instanceProto.onCreate = function()
	{
		this.atArray = new Array();
		this.atArrayMask = new Array();
		this.atWidth = 0;
		this.atHeight = 0;
		this.atList = new Array;
		
		for(var i=0;i<256;i++) {
			this.atList[i] = -1;
		}
		
		this.atList[2] = 1;
		this.atList[8] = 2;
		this.atList[10] = 3;
		this.atList[11] = 4;
		this.atList[16] = 5;
		this.atList[18] = 6;
		this.atList[22] = 7;
		this.atList[24] = 8;
		this.atList[26] = 9; 
		this.atList[27] = 10;
		this.atList[30] = 11;
		this.atList[31] = 12;
		this.atList[64] = 13;
		this.atList[66] = 14;
		this.atList[72] = 15;
		this.atList[74] = 16;
		this.atList[75] = 17;
		this.atList[80] = 18;
		this.atList[82] = 19;
		this.atList[86] = 20;
		this.atList[88] = 21;
		this.atList[90] = 22;
		this.atList[91] = 23;
		this.atList[94] = 24;
		this.atList[95] = 25;
		this.atList[104] = 26;
		this.atList[106] = 27;
		this.atList[107] = 28;
		this.atList[120] = 29;
		this.atList[122] = 30;
		this.atList[123] = 31;
		this.atList[126] = 32;
		this.atList[127] = 33;
		this.atList[208] = 34;
		this.atList[210] = 35;
		this.atList[214] = 36;
		this.atList[216] = 37;
		this.atList[218] = 38;
		this.atList[219] = 39;
		this.atList[222] = 40;
		this.atList[223] = 41;
		this.atList[248] = 42;
		this.atList[250] = 43;
		this.atList[251] = 44;
		this.atList[254] = 45;
		this.atList[255] = 46;
		this.atList[0] = 47;
		
		//this.atList = {2=1,8=2,10=3,11=4,16=5,18=6,22=7,24=8,26=9,27=10,30=11,31=12,64=13,66=14,72=15,74=16,75=17,80=18,82=19,86=20,88=21,90=22,91=23,94=24,95=25,104=26,106=27,107=28,120=29,122=30,123=31,
		// 126=32,127=33,208=34,210=35,214=36,216=37,218=38,219=39,222=40,223=41,248=42,250=43,251=44,254=45,255=46,0=47};

		// note the object is sealed after this call; ensure any properties you'll ever need are set on the object
		// e.g...
		// this.myValue = 0;
	};
	
	// only called if a layout object - draw to a canvas 2D context
	instanceProto.draw = function(ctx)
	{
	};
	
	// only called if a layout object in WebGL mode - draw to the WebGL context
	// 'glw' is not a WebGL context, it's a wrapper - you can find its methods in GLWrap.js in the install
	// directory or just copy what other plugins do.
	instanceProto.drawGL = function (glw)
	{
	};

	instanceProto.onDestroy = function ()
	{
		this.atArray = null;
		this.atArrayMask = null;
		//this.atList = null;
	}
	
	instanceProto.setSize = function(w,h) {
	
		// Array erstellen
		this.atArray = new Array();
		this.atArrayMask = new Array();
		
		this.atWidth = w;
		this.atHeight = h;
		
		for(var ii=0;ii<w;ii++){
			// Array erweitern!
			this.atArray[ii] = new Array();
			this.atArrayMask[ii] = new Array();
			
			for(var i=0;i<h;i++) {
				this.atArray[ii][i] = -1;
				this.atArrayMask[ii][i] = false;
			}
		}
		
	}
	
	instanceProto.setSizeAndFill = function(w,h,id) {
	
		// Array erstellen
		this.atArray = new Array();
		this.atArrayMask = new Array();
		
		this.atWidth = w;
		this.atHeight = h;
		
		for(var ii=0;ii<w;ii++){
			// Array erweitern!
			this.atArray[ii] = new Array();
			this.atArrayMask[ii] = new Array();
			
			for(var i=0;i<h;i++) {
				this.atArray[ii][i] = id;
				this.atArrayMask[ii][i] = true;
			}
		}
		
	}
	
	
	// 9 Tiles überprüfen
	function checkTile9(xx,yy,arr,arrmsk,wdt,hgt,list) {

		var x = xx;
		var y = yy;
		var current = 0;
		
		for(var i=0;i<8;i++) {

			if (x > 0 && x <= wdt - 1 && y > 0 && y <= hgt - 1) {
			
				if(typeof arrmsk[x][y] !== 'undefined') {
					if(arrmsk[x][y]==true) {
						
							// Zunächst dieses Tile auf -1 setzen!
							arr[x][y] = 0;
							
							// Oben
							if (x > 0 && x <= wdt - 1 && y-1 > 0 && y-1 <= hgt - 1) {
								if(arrmsk[x][y-1]==true) {arr[x][y]+=2;}
							} else {
								arr[x][y]+=2;
							}
							
							// Rechts
							if (x+1 > 0 && x+1 <= wdt - 1 && y > 0 && y <= hgt - 1) {
								if(arrmsk[x+1][y]==true) {arr[x][y]+=16;}
							} else {
								arr[x][y]+=16;
							}
							
							// Unten
							if (x > 0 && x <= wdt - 1 && y+1 > 0 && y+1 <= hgt - 1) {
								if(arrmsk[x][y+1]==true) {arr[x][y]+=64;}
							} else {
								arr[x][y]+=64;
							}
							
							// Links
							if (x-1 > 0 && x-1 <= wdt - 1 && y > 0 && y <= hgt - 1) {
								if(arrmsk[x-1][y]==true) {arr[x][y]+=8;}
								
							} else {
								arr[x][y]+=8;
							}
							

								// Oben links
								if (x-1 > 0 && x-1 <= wdt - 1 && y-1 > 0 && y-1 <= hgt - 1) {
									if(arrmsk[x-1][y-1]==true) { // Oben Links check...
										if((arrmsk[x][y-1]==true)&&(arrmsk[x-1][y]==true)) { // .. rechts daneben oder unten drunter
											arr[x][y]+=1;
										}
									}
								}


								// Oben Rechts
								if (x+1 > 0 && x+1 <= wdt - 1 && y-1 > 0 && y-1 <= hgt - 1) {
									if(arrmsk[x+1][y-1]==true) { // Oben Rechts check...
										if((arrmsk[x][y-1]==true)&&(arrmsk[x+1][y]==true)) { // .. links daneben oder unten drunter
											arr[x][y]+=4;
										}
									}
								}

							

								// Unten Rechts
								if (x+1 > 0 && x+1 <= wdt - 1 && y+1 > 0 && y+1 <= hgt - 1) {
									if(arrmsk[x+1][y+1]==true) { // Unten Rechts check...
										if((arrmsk[x][y+1]==true)&&(arrmsk[x+1][y]==true)) { // .. links daneben oder oben drüber
											arr[x][y]+=128;
										}
									}
								}

							
								// Unten Links
								if (x-1 > 0 && x-1 <= wdt - 1 && y+1 > 0 && y+1 <= hgt - 1) {
									if(arrmsk[x-1][y+1]==true) { // Unten Links check...
										if((arrmsk[x][y+1]==true)&&(arrmsk[x-1][y]==true)) { // .. rechts daneben oder oben drüber
											arr[x][y]+=32;
										}
									}
								}
							
							// Den Wert mit der Liste abgleichen
							if(arr[x][y]!=-1) {
								var value = arr[x][y];
								var fromlist = list[value];
								
								if(fromlist != -1) {
									arr[x][y] = fromlist;
								}
							}
							
							
					} else { arr[x][y] = -1; }
				}
			}
			
			current++;
			switch(current) {
				case 1:
					x--;
				break;
				case 2:
					y--;
				break;
				case 3:
					x++;
				break;
				case 4:
					x++;
				break;
				case 5:
					y++;
				break;
				case 6:
					y++;
				break;
				case 7:
					x--;
				break;
				case 8:
					x--;
				break;
				
				case 9: // Ende der Überprüfung
					i=8;
				break;
			}
			
		}
	}
	
	function tilecorrection() {
		// Den Wert mit der Liste abgleichen
		if(arr[x][y]!=-1) {
			var value = arr[x][y];
			var fromlist = list[value];
			
			if(fromlist != -1) {
				arr[x][y] = fromlist;
			}
		}
	}
	
	
	// 5 Tiles überprüfen
	function checkTile(xx,yy,arr,arrmsk,wdt,hgt) {

		var x = xx;
		var y = yy;
		var current = 0;
		
		for(var i=0;i<8;i++) {

			if (x > 0 && x <= wdt - 1 && y > 0 && y <= hgt - 1) {
			
				if(typeof arrmsk[x][y] !== 'undefined') {
					if(arrmsk[x][y]==true) {
						
							// Zunächst dieses Tile auf -1 setzen!
							arr[x][y] = 0;
							
							// Oben
							if (x > 0 && x <= wdt - 1 && y-1 > 0 && y-1 <= hgt - 1) {
								if(arrmsk[x][y-1]==true) {arr[x][y]+=1;}
							} else {
								arr[x][y]+=1;
							}
							
							// Rechts
							if (x+1 > 0 && x+1 <= wdt - 1 && y > 0 && y <= hgt - 1) {
								if(arrmsk[x+1][y]==true) {arr[x][y]+=2;}
							} else {
								arr[x][y]+=2;
							}
							
							// Unten
							if (x > 0 && x <= wdt - 1 && y+1 > 0 && y+1 <= hgt - 1) {
								if(arrmsk[x][y+1]==true) {arr[x][y]+=4;}
							} else {
								arr[x][y]+=4;
							}
							
							// Links
							if (x-1 > 0 && x-1 <= wdt - 1 && y > 0 && y <= hgt - 1) {
								if(arrmsk[x-1][y]==true) {arr[x][y]+=8;}
								
							} else {
								arr[x][y]+=8;
							}
							
					} else { arr[x][y] = -1; }
				}
			}
			
			current++;
			switch(current) {
				case 1:
					x--;
				break;
				case 2:
					y--;
				break;
				case 3:
					x++;
				break;
				case 4:
					x++;
				break;
				case 5:
					y++;
				break;
				case 6:
					y++;
				break;
				case 7:
					x--;
				break;
				case 8:
					x--;
				break;
				
				case 9: // Ende der Überprüfung
					i=8;
				break;
			}
			
		}
	}
	
	instanceProto.setTile9 = function(x,y) {
		if (isNaN(x) || x < 0 || x > this.atWidth - 1) {return;}
		if (isNaN(y) || y < 0 || y > this.atHeight - 1) {return;}

		// Tile der "Maske" auf true setzen
		this.atArrayMask[x][y] = true;
		
		checkTile9(x,y,this.atArray,this.atArrayMask,this.atWidth,this.atHeight,this.atList);
		checkTile9(x-1,y-1,this.atArray,this.atArrayMask,this.atWidth,this.atHeight,this.atList);
		checkTile9(x,y-1,this.atArray,this.atArrayMask,this.atWidth,this.atHeight,this.atList);
		checkTile9(x+1,y,this.atArray,this.atArrayMask,this.atWidth,this.atHeight,this.atList);
		checkTile9(x+1,y+1,this.atArray,this.atArrayMask,this.atWidth,this.atHeight,this.atList);
		checkTile9(x,y+1,this.atArray,this.atArrayMask,this.atWidth,this.atHeight,this.atList);
		checkTile9(x-1,y+1,this.atArray,this.atArrayMask,this.atWidth,this.atHeight,this.atList);
		checkTile9(x-1,y,this.atArray,this.atArrayMask,this.atWidth,this.atHeight,this.atList);
	}
	
	instanceProto.eraseTile9 = function(x,y) {
	
		if (isNaN(x) || x < 0 || x > this.atWidth - 1) {return;}
		if (isNaN(y) || y < 0 || y > this.atHeight - 1) {return;}

		// Tile der "Maske" auf true setzen
		this.atArrayMask[x][y] = false;
		
		checkTile9(x,y,this.atArray,this.atArrayMask,this.atWidth,this.atHeight,this.atList);
		checkTile9(x-1,y-1,this.atArray,this.atArrayMask,this.atWidth,this.atHeight,this.atList);
		checkTile9(x,y-1,this.atArray,this.atArrayMask,this.atWidth,this.atHeight,this.atList);
		checkTile9(x+1,y,this.atArray,this.atArrayMask,this.atWidth,this.atHeight,this.atList);
		checkTile9(x+1,y+1,this.atArray,this.atArrayMask,this.atWidth,this.atHeight,this.atList);
		checkTile9(x,y+1,this.atArray,this.atArrayMask,this.atWidth,this.atHeight,this.atList);
		checkTile9(x-1,y+1,this.atArray,this.atArrayMask,this.atWidth,this.atHeight,this.atList);
		checkTile9(x-1,y,this.atArray,this.atArrayMask,this.atWidth,this.atHeight,this.atList);
	}
	
	instanceProto.setTile5 = function(x,y) {
		if (isNaN(x) || x < 0 || x > this.atWidth - 1) {return;}
		if (isNaN(y) || y < 0 || y > this.atHeight - 1) {return;}

		// Tile der "Maske" auf true setzen
		this.atArrayMask[x][y] = true;
		
		checkTile(x,y,this.atArray,this.atArrayMask,this.atWidth,this.atHeight);
		checkTile(x-1,y-1,this.atArray,this.atArrayMask,this.atWidth,this.atHeight);
		checkTile(x,y-1,this.atArray,this.atArrayMask,this.atWidth,this.atHeight);
		checkTile(x+1,y,this.atArray,this.atArrayMask,this.atWidth,this.atHeight);
		checkTile(x+1,y+1,this.atArray,this.atArrayMask,this.atWidth,this.atHeight);
		checkTile(x,y+1,this.atArray,this.atArrayMask,this.atWidth,this.atHeight);
		checkTile(x-1,y+1,this.atArray,this.atArrayMask,this.atWidth,this.atHeight);
		checkTile(x-1,y,this.atArray,this.atArrayMask,this.atWidth,this.atHeight);
	}
	
	instanceProto.eraseTile = function(x,y) {
	
		if (isNaN(x) || x < 0 || x > this.atWidth - 1) {return;}
		if (isNaN(y) || y < 0 || y > this.atHeight - 1) {return;}

		// Tile der "Maske" auf true setzen
		this.atArrayMask[x][y] = false;
		
		checkTile(x,y,this.atArray,this.atArrayMask,this.atWidth,this.atHeight);
		checkTile(x-1,y-1,this.atArray,this.atArrayMask,this.atWidth,this.atHeight);
		checkTile(x,y-1,this.atArray,this.atArrayMask,this.atWidth,this.atHeight);
		checkTile(x+1,y,this.atArray,this.atArrayMask,this.atWidth,this.atHeight);
		checkTile(x+1,y+1,this.atArray,this.atArrayMask,this.atWidth,this.atHeight);
		checkTile(x,y+1,this.atArray,this.atArrayMask,this.atWidth,this.atHeight);
		checkTile(x-1,y+1,this.atArray,this.atArrayMask,this.atWidth,this.atHeight);
		checkTile(x-1,y,this.atArray,this.atArrayMask,this.atWidth,this.atHeight);
	}
	
	
	instanceProto.getTile = function(x,y) {
	if(typeof this.atArray[x][y] !== 'undefined') {
			return this.atArray[x][y];
		} else {return -1;}
	}
	
	
	instanceProto.getDebuggerValues = function (propsections)
	{
		propsections.push({
			"title": "Massive Cube - Autotiling",
			"properties": [
				{"name": "Width", "value": this.atArray.length, "readonly": true},
				{"name": "Height", "value": this.atArray[0].length, "readonly": true},
				{"name": "Total elements", "value": (this.atArray.length*this.atArray[0].length), "readonly": true}
			]
		});
		
		var props = [];
		var x;
		
		for (x = 0; x < this.atArray.length; x++)
		{
			props.push({"name": x.toString(), "value": this.atArray[x].toString(), "readonly": true});
		}
		
		
		if (props.length)
		{
			propsections.push({
				"title": "Array data",
				"properties": props
			});
		}
	}
	
	
	//////////////////////////////////////
	// Conditions
	function Cnds() {};

	// the example condition
	//Cnds.prototype.MyCondition = function (myparam)
	//{
		// return true if number is positive
	//	return myparam >= 0;
	//};
	
	// ... other conditions here ...
	
	pluginProto.cnds = new Cnds();
	
	//////////////////////////////////////
	// Actions
	function Acts() {};

	// the example action
	Acts.prototype.asetSize = function (ww,hh)
	{
		// Arraygröße setzen
		this.setSize(ww,hh);
	};
	
	Acts.prototype.setSizeAndFill = function (ww,hh,iid)
	{
		// Arraygröße setzen
		this.setSizeAndFill(ww,hh,iid);
	};
	
	Acts.prototype.asetTile = function (xx,yy)
	{
		// Tile setzen und "berechnen"
		this.setTile5(xx,yy);
	};
	
	Acts.prototype.settile9 = function (xx,yy)
	{
		// Tile setzen und "berechnen"
		this.setTile9(xx,yy);
	};
	
	Acts.prototype.aeraseTile = function (xx,yy)
	{
		// Tile löschen bzw. auf -1 stellen
		this.eraseTile(xx,yy);
	};
	
	
	Acts.prototype.eraseTile9 = function (xx,yy)
	{
		// Tile löschen bzw. auf -1 stellen
		this.eraseTile9(xx,yy);
	};
	
	// ... other actions here ...
	
	pluginProto.acts = new Acts();
	
	//////////////////////////////////////
	// Expressions
	function Exps() {};
	
	// the example expression
	Exps.prototype.getTile = function (ret,xx,yy)	// 'ret' must always be the first parameter - always return the expression's result through it!
	{
	
		ret.set_int(this.getTile(xx,yy));
		// ret.set_float(0.5);			// for returning floats
		// ret.set_string("Hello");		// for ef_return_string
		// ret.set_any("woo");			// for ef_return_any, accepts either a number or string
	};
	
	Exps.prototype.AsJSONRAW = function (ret)
	{
		ret.set_string(JSON.stringify(this.atArray));
	};	
	
	// ... other expressions here ...
	
	pluginProto.exps = new Exps();

}());