"use strict";
{
	const C3 = self.C3;
	
	let oldC3Layer = C3.Layer
	C3.Layer = class extends oldC3Layer {
		constructor(...args) {
			super(...args)
			this.saveSlots = {}
			this.beforeDrawSlot = null;
			this.preventDefault = false;
			this.keepBackground = false;
			this.doKeepBackground = false;
		}
		IsTransparent() {
	        return this._isTransparent || this.keepBackground;
	    }
		_sky_superDraw() {
			const {renderer, destinationRenderTarget, isFirstToTarget} = C3._sky_layerMagic.lastArgs;
			this.keepBackground = this.doKeepBackground;
			super.Draw(renderer, destinationRenderTarget, isFirstToTarget);
			this.keepBackground = false;
			C3._sky_layerMagic.lastArgs.isFirstToTarget = false;
		}
		_sky_drawOldTexture() {
			if (!this.UsesOwnTexture()) return;
			const {renderer, destinationRenderTarget, isFirstToTarget} = this.prevArgs;
			this._DrawLayerOwnTextureToRenderTarget(renderer, this._curRenderTarget, destinationRenderTarget, isFirstToTarget)
			C3._sky_layerMagic.lastArgs = {...this.prevArgs};
		}
		_sky_saveSlot(slot) {
			this.saveSlots[slot] = this._SaveToJson();
		}
		_sky_loadSlot(slot) {
			if (this.saveSlots[slot])
				this._LoadFromJson(this.saveSlots[slot]);
		}
		_sky_preventDefault() {
			this.preventDefault = true;
		}
		Draw(renderer, destinationRenderTarget, isFirstToTarget) {
			this.prevArgs = {...C3._sky_layerMagic.lastArgs};
			C3._sky_layerMagic.lastArgs = {renderer, destinationRenderTarget, isFirstToTarget};
			this.preventDefault = false;
			this.beforeDrawSlot = this._SaveToJson();
			
			// shenanigans
			C3._sky_layerMagic.TriggerLayerDraw(this);
			
			this._LoadFromJson(this.beforeDrawSlot);
			
			if (!this.preventDefault) this._sky_superDraw();
		}
	}

	C3.Plugins.skymen_LayerMagic.Instance = class LayerMagicInstance extends C3.SDKInstanceBase
	{
		constructor(inst, properties)
		{
			super(inst);
			
			
			if (properties)
			{
			}
			this._curLayerName = "";
			this._curLayer = null;
			C3._sky_layerMagic = this;
		}
		
		Release()
		{
			super.Release();
		}
		
		DoSaveState(layer, slot) {
			layer._sky_saveSlot(slot)
		}
		DoLoadState(layer, slot) {
			layer._sky_loadSlot(slot)
		}
		DoKeepBackground(layer, state) {	
			layer.doKeepBackground = state;
		}
		DoDrawOldTexture(layer) {
			layer._sky_drawOldTexture()
		}
		DoPreventDefaultDraw() {
			if (this._curLayer) this._curLayer._sky_preventDefault();
		}
		DoDrawLayer(layer) {
			layer._sky_superDraw();
		}
		isLayerDrawing(layer) {
			return layer === this._curLayer;
		}
		
		TriggerLayerDraw(layer) {
			this._curLayer = layer;
			this._curLayerName = layer._name;
			this.Trigger(C3.Plugins.skymen_LayerMagic.Cnds.OnAnyLayerDraw)
			this.Trigger(C3.Plugins.skymen_LayerMagic.Cnds.OnLayerDraw)
			this._curLayer = null;
			this._curLayerName = "";
		}
		
		SaveToJson()
		{
			return {
				// data to be saved for savegames
			};
		}
		
		LoadFromJson(o)
		{
			// load state for savegames
		}

        GetDebuggerProperties()
		{
			return [{
				title: "LayerMagic",
				properties: [
					//{name: ".current-animation",	value: this._currentAnimation.GetName(),	onedit: v => this.CallAction(Acts.SetAnim, v, 0) },
				]
			}];
		}

		// timeline support
		GetPropertyValueByIndex(index)
		{
			return 0;
		}

		SetPropertyValueByIndex(index, value)
		{
			//set property value here
		}
	};
}