/////////////////////////////////////////////////////////
// @XorDev's Disk Blur

precision highp float;

//Blur radius in pixels
uniform mediump float u_radius;

//Texture coordinates
varying mediump vec2 vTex;

//Construct uniforms
uniform mediump vec2 srcOriginStart;
uniform mediump vec2 srcOriginEnd;
uniform mediump vec2 layoutStart;
uniform mediump vec2 layoutEnd;
uniform lowp sampler2D samplerFront;

//Number of samples in blur (higher = smoother, slower)
#define SAMPLES 24.0

void main(void)
{
	//Initialize blur output color
	mediump vec4 blur = vec4(0.0, 0.0, 0.0, 0.0);
	//Total weight from all samples
	mediump float total = 0.0;
	
	//Compute mipmap level from radius
	mediump float mip = log2(u_radius);

	//First sample offset scale
	mediump float scale = u_radius * inversesqrt(SAMPLES);
	
	//Starting sample point
	highp vec2 point = vec2(scale, 0.0);

	//Calculate texel size
	mediump vec2 layout_size = layoutEnd - layoutStart;
	mediump vec2 texel_size = (srcOriginEnd - srcOriginStart) / layout_size;

	//Radius iteration variable
	mediump float rad = 1.0;
	//Golden angle rotation matrix
	highp mat2 ang = mat2(-0.7373688, -0.6754904, 0.6754904,  -0.7373688);

	//Look through all the samples
	for(float i = 0.0; i<SAMPLES; i++)
	{
		//Rotate point direction
		point *= ang;
		//Iterate radius variable. Approximately 1+sqrt(i)
		rad += 1.0 / rad;

		//Get sample coordinates
		mediump vec2 coord = vTex + point * (rad - 1.0) * texel_size;
		//Set sample weight
		mediump float weight = 1.0 / rad;
		//Check if inside texture
		lowp vec4 samp = (clamp(vTex, 0.0, 1.0) == vTex)?
        //Sample texture, or blank
        texture2D(samplerFront, coord, mip) : vec4(0.0, 0.0, 0.0, 0.0);

		//Add sample and weight totals
		blur += samp * weight;
		total += weight;
	}
	//Divide the blur total by the weight total
	blur /= total;
	//Output result
	gl_FragColor = blur;
}