const SDK = self.SDK;

const PLUGIN_CLASS = SDK.Plugins.skymen_VanillaPlusColorPicker;

PLUGIN_CLASS.Instance = class skymen_VanillaPlusColorPickerDOMInstance extends (
  SDK.IWorldInstanceBase
) {
  constructor(sdkType, inst) {
    super(sdkType, inst);

    // Lazy-created IWebGLText object for button text
    this._webglText = null;
  }

  Release() {
    // Release the WebGL text if it was created
    if (this._webglText) {
      this._webglText.Release();
      this._webglText = null;
    }
  }

  OnCreate() {
    // Default to top-left origin
    this._inst.SetOrigin(0, 0);
  }

  OnPlacedInLayout() {
    // Set default size
    this._inst.SetSize(72, 30);
  }

  // Render a button label on a grey background for the editor as a placeholder.
  // Note the pixel-snapping path for text rendering is omitted for brevity. See the editorTextPlugin
  // template for a full text rendering implementation.
  Draw(iRenderer, iDrawParams) {
    const iLayoutView = iDrawParams.GetLayoutView();

    this._inst.ApplyBlendMode(iRenderer);
    iRenderer.SetColorFillMode();

    const quad = this._inst.GetQuad();

    // Draw grey fill and black outline for button background
    iRenderer.SetColorRgba(0.8, 0.8, 0.8, 1);
    iRenderer.Quad(quad);

    iRenderer.SetColorRgba(0, 0, 0, 1);
    iRenderer.LineQuad(quad);

	let paddingH = 6;
	let paddingV = 6;
	if (this._inst.GetWidth() < paddingH * 2 + 1 || this._inst.GetHeight() < paddingV * 2 + 1) return;
	let quadColor = new SDK.Quad();
	quadColor.setRect(quad.getTlx() + paddingH, quad.getTly() + paddingV, quad.getBrx() - paddingH, quad.getBry() - paddingV)
	iRenderer.SetColor(this._inst.GetPropertyValue("color"));
    iRenderer.Quad(quadColor);
  }

  OnPropertyChanged(id, value) {}

  LoadC2Property(name, valueString) {
    return false; // not handled
  }
};