const C3 = self.C3;

// NOTE: use a unique DOM component ID to ensure it doesn't clash with anything else.
// This must also match the ID in plugin.js and domSide.js.
const DOM_COMPONENT_ID = "skymen-vanillapluscolorpicker";

function hexToRgb(hex) {
  var result = /^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i.exec(hex);
  return result
    ? [
        parseInt(result[1], 16)/255,
        parseInt(result[2], 16)/255,
        parseInt(result[3], 16)/255,
      ]
    : [0, 0, 0];
}

// NOTE: DOM instances derive from C3.SDKDOMInstanceBase, not C3.SDKWorldInstanceBase.
C3.Plugins.skymen_VanillaPlusColorPicker.Instance = class skymen_VanillaPlusColorPickerInstance extends (
  C3.SDKDOMInstanceBase
) {
  constructor(inst, properties) {
    super(inst, DOM_COMPONENT_ID);

    // Keep a copy of the button text on the instance, so it can be returned from an expression.
    this._color = [0,0,0];
    this._tempColor = C3.New(C3.Color);

    if (properties) {
      this._color = properties[0];
    }

    // Create an element for this instance. The runtime handles this and will result in a call
    // to CreateElement() in domSide.js where the real DOM calls are made.
    this.CreateElement();
  }

  Release() {
    super.Release();
  }

  GetElementState() {
    // Return JSON with the state of the element. This is passed along to both CreateElement()
    // and UpdateState() in domSide.js. It provides a convenient way to send all the DOM element
    // state in one go, ensuring any changes are reflected in the real element.
    return {
      color: this._color,
    };
  }

  // Called when the button is clicked. This is done by attaching a "click" handler in domSide.js
  // which calls PostToRuntimeElement() to send a "click" message to the plugin. The plugin then
  // forwards it to the instance by calling this method (see plugin.js). Note if an object was passed in
  // the third parameter to PostToRuntimeElement(), this will be passed along as the parameter here,
  // but in this case it's not used.
  _OnClick(e) {
    // Dispatch script event so callers can use addEventListener("click", ...)
    this.GetScriptInterface().dispatchEvent(new C3.Event("click", true));

    // Trigger 'On click' in the event system
    this.Trigger(C3.Plugins.skymen_VanillaPlusColorPicker.Cnds.OnClick);
  }
  
  _OnInput(e) {
    // Dispatch script event so callers can use addEventListener("click", ...)
    this._color = hexToRgb(e.value);
    this.GetScriptInterface().dispatchEvent(new C3.Event("input", true));

    // Trigger 'On click' in the event system
    this.Trigger(C3.Plugins.skymen_VanillaPlusColorPicker.Cnds.OnInput);
  }
  
  _OnChange(e) {
    // Dispatch script event so callers can use addEventListener("click", ...)
    this._color = hexToRgb(e.value);
    this.GetScriptInterface().dispatchEvent(new C3.Event("change", true));

    // Trigger 'On click' in the event system
    this.Trigger(C3.Plugins.skymen_VanillaPlusColorPicker.Cnds.OnChange);
  }

  _SetColor(color) {
    this._color = color;
    this.UpdateElementState();
  }

  _GetColor() {
    return this._color;
  }

  _SetColorC3(rgb) {
  	this._tempColor.setFromRgbValue(rgb);
  	this._SetColor([this._tempColor.getR(),this._tempColor.getG(),this._tempColor.getB()])
  }
  _GetColorC3(color) {
  	return C3.PackRGBAEx(...this._color, 1)
  }
  _SetR(r) {
  	this._color[0] = r;
    this.UpdateElementState();
  }
  _SetG(g) {
  	this._color[1] = g;
    this.UpdateElementState();
  }
  _SetB(b) {
  	this._color[2] = b;
    this.UpdateElementState();
  }

  Draw(renderer) {
    // not used - a DOM element is positioned at this instance instead
  }

  SaveToJson() {
    return {
      // data to be saved for savegames
      ...this.GetElementState()
    };
  }

  LoadFromJson(o) {
    // load state for savegames
    this._color = o["color"];

    this.UpdateElementState(); // ensures any state changes are updated in the DOM
  }

  GetScriptInterfaceClass() {
    return self.skymen_VanillaPlusColorPickerDomInstance;
  }
};

// Script interface. Use a WeakMap to safely hide the internal implementation details from the
// caller using the script interface.
const map = new WeakMap();

self.skymen_VanillaPlusColorPickerDomInstance = class skymen_VanillaPlusColorPickerDomInstance extends (
  self.IDOMInstance
) {
  constructor() {
    super();

    // Map by SDK instance
    map.set(this, self.IInstance._GetInitInst().GetSdkInstance());
  }

  // Example setter/getter property on script interface
  set color(c) {
    map.get(this)._SetColor(c);
  }

  get color() {
    return map.get(this)._GetColor();
  }
};