precision mediump float;
uniform lowp float blursize;
uniform lowp float bloomvalue;
uniform lowp float bloomthreshold;

/////////////////////////////////////////////////////////
// GaussianBlur

//The current foreground texture co-ordinate
varying mediump vec2 vTex;
//The foreground texture sampler, to be sampled at vTex
uniform lowp sampler2D samplerFront;
//The current foreground rectangle being rendered
uniform mediump vec2 srcStart;
uniform mediump vec2 srcEnd;
//The current foreground source rectangle being rendered
uniform mediump vec2 srcOriginStart;
uniform mediump vec2 srcOriginEnd;
//The current foreground source rectangle being rendered, in layout 
uniform mediump vec2 layoutStart;
uniform mediump vec2 layoutEnd;
//The background texture sampler used for background - blending effects
uniform lowp sampler2D samplerBack;
//The current background rectangle being rendered to, in texture co-ordinates, for background-blending effects
uniform mediump vec2 destStart;
uniform mediump vec2 destEnd;
//The time in seconds since the runtime started. This can be used for animated effects
uniform mediump float seconds;
//The size of a texel in the foreground texture in texture co-ordinates
uniform mediump vec2 pixelSize;
//The current layer scale as a factor (i.e. 1 is unscaled)
uniform mediump float layerScale;
//The current layer angle in radians.
uniform mediump float layerAngle;

const lowp float Quality = 4.0;
const lowp float Directions = 32.0;
const mediump float Pi = 6.28318530718;//pi * 2

lowp float luminance(vec3 rgb)
{
    const mediump vec3 W = vec3(0.2125, 0.7154, 0.0721);
    return dot(rgb, W);
}

void main(void)
{
  
  //lowp vec2 radius = size.z/size.xy;
  
  lowp vec2 radius = vec2(blursize*0.01);
  lowp vec4 oColor = texture2D( samplerFront, vTex);
  lowp vec4 Color = oColor;
  
  for( lowp float d=0.0;d<Pi;d+=Pi/float(Directions) )
    {
        for( lowp float     i=1.0/float(Quality);i<=1.0;i+=1.0/float(Quality) )
        {
                lowp vec4 sampleColor = texture2D( samplerFront, vTex+vec2(cos(d),sin(d))*radius*i);
                Color += bloomvalue == 0.0 ? sampleColor : luminance(sampleColor.rgb) > bloomthreshold ? sampleColor : vec4(0.0); 
        }
    }
    Color /= float(Quality)*float(Directions)+1.0;
    if(bloomvalue>0.0)
      gl_FragColor =  Color*bloomvalue*0.1+texture2D( samplerFront, vTex);
    else
      gl_FragColor =  Color;
  

}