"use strict";
{
  const C3 = globalThis.C3;

  C3.Plugins.scormc2.Instance = class C3ScormPluginInstance extends globalThis.ISDKInstanceBase {
    constructor() {
      super();

      runOnStartup(async runtime => {
        // Code to run on the loading screen.
        // Note layouts, objects etc. are not yet available.

        this.previewMode = runtime.platformInfo.exportType === "preview";
      });
      // Initialise object properties
      this.isScormInitialised = false;
      this.isOnError = false;
      /*       this.previewMode = inst.GetRuntime().IsPreview(); */
      if (this.previewMode) {
        console.log(
          "[scorm preview] C3 running in preview, scorm preview mode enabled."
        );
      }
    }

    _release() {
      super._release();
    }

    SaveToJson() {
      return {
        // data to be saved for savegames
      };
    }

    LoadFromJson(o) {
      // load state for savegames
    }

    GetDebuggerProperties() {
      return [
        {
          title: "C3ScormPlugin",
          properties: [
            //{name: ".current-animation",	value: this._currentAnimation.GetName(),	onedit: v => this.CallAction(Acts.SetAnim, v, 0) },
          ]
        }
      ];
    }

    // timeline support
    GetPropertyValueByIndex(index) {
      return 0;
    }

    SetPropertyValueByIndex(index, value) {
      //set property value here
    }
  };
}
