"use strict";
const pipwerks = globalThis.pipwerks;
{
  globalThis.C3.Plugins.scormc2.Acts = {
    initialiseLMS() {
      if (this.previewMode) {
        this.isScormInitialised = true;
        console.log("[scorm preview] pipwerks.SCORM.init()");
        return;
      }
      const result = pipwerks.SCORM.init();
      if (result) {
        this.isScormInitialised = true;
      } else {
        this.isScormInitialised = false;
        this.isOnError = true;
      }
    },

    setLMSValue(name, value) {
      if (this.previewMode) {
        console.log(`[scorm preview] pipwerks.SCORM.set(${name}, ${value})`);
        return;
      }
      if (this.isScormInitialised) {
        this.isOnError = !pipwerks.SCORM.set(name, value);
      }
    },

    doLMSCommit() {
      if (this.previewMode) {
        console.log(`[scorm preview] pipwerks.SCORM.save()`);
        return;
      }
      if (this.isScormInitialised) {
        this.isOnError = !pipwerks.SCORM.save();
      }
    },

    doTerminate() {
      if (this.previewMode) {
        console.log(`[scorm preview] pipwerks.SCORM.quit()`);
        return;
      }
      if (this.isScormInitialised) {
        this.isOnError = !pipwerks.SCORM.quit();
      }
    }
  };
}
