"use strict";

{
	const C3 = self.C3;
	C3.Plugins.Rex_SequenceMatcher.Instance = class Rex_SequenceMatcherInstance extends C3.SDKInstanceBase
	{
		constructor(inst, properties)
		{
			super(inst);
			this.hasMatchedPattern = false;
			if (properties)
			{
				this.symbolBuffer = new C3.Plugins.Rex_SequenceMatcher.BufferKlass(properties[0]);
			}
		}
		Release()
		{
			super.Release();
		}
		pushSymbol(s)	
		{
			this.symbolBuffer.pushData(s);
			this.hasMatchedPattern = false;
			this.Trigger(C3.Plugins.Rex_SequenceMatcher.Cnds.OnMatchPattern, this);
			if (!this.hasMatchedPattern)
				this.Trigger(C3.Plugins.Rex_SequenceMatcher.Cnds.OnNoMatchPattern, this);
		}		
		SaveToJson()
		{
			return {
				"d": this.symbolBuffer.saveToJSON()
			};
		}
		LoadFromJson(o)
		{
			this.symbolBuffer.loadFromJSON(o["d"]);
		}
		GetDebuggerProperties()
		{
			return [{
				title: "plugins.rex_sequencematcher.name",
				properties: [
					{name: "Buffer", value: this.symbolBuffer.content2string("")}
				]
			}];
		}
	};
}