"use strict";

{
	const C3 = self.C3;
	C3.Behaviors.Rex_bNickname.Instance = class Rex_bNicknameInstance extends C3.SDKBehaviorInstanceBase
	{
		constructor(behInst, properties)
		{
			super(behInst);
			if (properties)
			{
				this.setNickname(properties[0], properties[1]);
			}
		}
		Release()
		{
			super.Release();
		}
		setNickname(name, m)
		{
			var nicknameObj = globalThis.RexC2NicknameObj;
			if (nicknameObj == null)
				return;
			var nickname = (m == 1) ? this._inst.GetObjectClass().GetSID().toString() : name;
			var savedNickname = nicknameObj.sid2nickname[this._inst.GetObjectClass().GetSID().toString()]; // try to get nickname from nickname plugin
			if (nickname == "") {
				this.nickname = savedNickname || "";
			} else {
				this.nickname = nickname;
				if (nickname !== savedNickname) {
					nicknameObj.AddNickname(nickname, this._inst.GetObjectClass());
				}
			}
		}
	};
}