"use strict";
{
	const SDK = self.SDK;

	const BEHAVIOR_ID = "skymenTrail";	
	const BEHAVIOR_VERSION = "1.0.2.1";
	const BEHAVIOR_CATEGORY = "general";
	
	const BEHAVIOR_CLASS = SDK.Behaviors.skymenTrail = class skymenTrailBehavior extends SDK.IBehaviorBase
	{
		constructor()
		{
			super(BEHAVIOR_ID);
			
			SDK.Lang.PushContext("behaviors." + BEHAVIOR_ID.toLowerCase());
			
			this._info.SetName(lang(".name"));
			this._info.SetDescription(lang(".description"));
			this._info.SetVersion(BEHAVIOR_VERSION);
			this._info.SetCategory(BEHAVIOR_CATEGORY);
			this._info.SetAuthor("skymen");
			this._info.SetHelpUrl(lang(".help-url"));
			this._info.SetIsOnlyOneAllowed(true);
			this._info.SetCanBeBundled(true);

			this._info.SetSupportedRuntimes(["c3"]);
			
			SDK.Lang.PushContext(".properties");
	
			this._info.SetProperties([
				new SDK.PluginProperty("integer", "length", 15),
				new SDK.PluginProperty("integer", "resolution", 1),
				new SDK.PluginProperty("float", "width-start", 20),
				new SDK.PluginProperty("float", "width-end", 0)

			]);
			
            SDK.Lang.PopContext(); //.properties
			SDK.Lang.PopContext();
		}
	};
	
	BEHAVIOR_CLASS.Register(BEHAVIOR_ID, BEHAVIOR_CLASS);
}