"use strict";

{
	C3.Plugins.sse_plugin.Acts =
	{
		connect(url)
		{
			var self = this;
			var sse = new EventSource(url);
			sse.onmessage = function(event){
				self.response = event.data;
				self.Trigger(C3.Plugins.sse_plugin.Cnds.onmessage);
			};
			sse.onopen= function(){
				self.Trigger(C3.Plugins.sse_plugin.Cnds.onopen);
			};
			sse.onerror = function(event){
				self.error = event.error;
				self.Trigger(C3.Plugins.sse_plugin.Cnds.onerror);
			}
			return;
		},
		Support()
		{
			if(typeof(EventSource) !== "undefined") {
				var self = this;
				self.Trigger(C3.Plugins.sse_plugin.Cnds.onSupport);
			  } else {
				self.error = "your browser not supported server-sent events(SSE)";
				var self = this;
				self.Trigger(C3.Plugins.sse_plugin.Cnds.onnotSupport);
			  }
		}
	};
}
