"use strict";
{

    const PLUGIN_ID = "EMI_INDO_Google_Translate";
    const PLUGIN_VERSION = "1.0.0.2";
    const PLUGIN_CATEGORY = "general";

    const PLUGIN_CLASS = SDK.Plugins.EMI_INDO_Google_Translate = class Google_TranslatePlugin extends SDK.IPluginBase
    {
        constructor()
        {
            super(PLUGIN_ID);

            SDK.Lang.PushContext("plugins." + PLUGIN_ID.toLowerCase());

            this._info.SetName(lang(".name"));
            this._info.SetDescription(lang(".description"));
            this._info.SetVersion(PLUGIN_VERSION);
            this._info.SetCategory(PLUGIN_CATEGORY);
            this._info.SetAuthor("EMI_INDO");
            this._info.SetHelpUrl(lang(".help-url"));
            this._info.SetIsSingleGlobal(true);

            this._info.SetSupportedRuntimes(["c3"]);

            this._info.SetAndroidXEnabled(true);


            const path = new SDK.PluginProperty("text", "ANDROID-FIREBASE-CONFIG-FILEPATH", "www/google-services.json");
            const a = new SDK.PluginProperty("text", "FIREBASE-ML-NATURAL-LANGUAGE-VERSION", "22.0.0");
            const b = new SDK.PluginProperty("text", "FIREBASE-ML-NATURAL-LANGUAGE-MODEL-VERSION", "20.0.7");
            const c = new SDK.PluginProperty("text", "FIREBASE-ML-NATURAL-LANGUAGE-ID-VERSION", "20.0.7");
            const pathios = new SDK.PluginProperty("text", "IOS-FIREBASE-CONFIG-FILEPATH", "www/GoogleService-Info.plist");


            SDK.Lang.PushContext(".properties");

            this._info.SetProperties([
            new SDK.PluginProperty("group", "Firebase-config-setup-android"),
            path,
            a,
            b,
            c,
            new SDK.PluginProperty("group", "Firebase-config-setup-ios"),
            pathios
            ]);

            this._info.AddCordovaPluginReference(
            {
                id: "cordova-plugin-mlkit-translate",
                plugin: this,
                variables: [
                        ["FIREBASE_ML_NATURAL_LANGUAGE_VERSION", a],
                        ["FIREBASE_ML_NATURAL_LANGUAGE_MODEL_VERSION", b],
                        ["FIREBASE_ML_NATURAL_LANGUAGE_ID_VERSION", c]
                    ]
            });

            this._info.AddCordovaPluginReference(
            {
                id: "cordova-plugin-firebasex",
                plugin: this,
                variables: [
                        ["ANDROID_FIREBASE_CONFIG_FILEPATH", path],
                        ["IOS_FIREBASE_CONFIG_FILEPATH", pathios]
                    ]
            });

            SDK.Lang.PopContext(); //.properties
            SDK.Lang.PopContext();
        }
    };

    PLUGIN_CLASS.Register(PLUGIN_ID, PLUGIN_CLASS);
}