"use strict";
{
    const SDK = self.SDK;

    const PLUGIN_ID = "EMI_INDO_FirebaseAnalytics";
    const PLUGIN_VERSION = "1.0.0.3";
    const PLUGIN_CATEGORY = "web";

    const PLUGIN_CLASS = SDK.Plugins.EMI_INDO_FirebaseAnalytics = class FirebaseAnalyticsPlugin extends SDK.IPluginBase
    {
        constructor()
        {
            super(PLUGIN_ID);

            SDK.Lang.PushContext("plugins." + PLUGIN_ID.toLowerCase());

            this._info.SetName(lang(".name"));
            this._info.SetDescription(lang(".description"));
            this._info.SetVersion(PLUGIN_VERSION);
            this._info.SetCategory(PLUGIN_CATEGORY);
            this._info.SetAuthor("EMI_INDO");
            this._info.SetHelpUrl(lang(".help-url"));
            this._info.SetIsSingleGlobal(true);

            this._info.SetSupportedRuntimes(["c3"]);
            this._info.SetAndroidXEnabled(true);
            this._info.SetGooglePlayServicesEnabled(true);

            const path = new SDK.PluginProperty("text", "ANDROID-FIREBASE-CONFIG-FILEPATH", "www/google-services.json");
            const android = new SDK.PluginProperty("text", "ANDROID-FIREBASE-ANALYTICS-VERSION", "18.0.2");
            const pathios = new SDK.PluginProperty("text", "IOS-FIREBASE-CONFIG-FILEPATH", "www/GoogleService-Info.plist");


            SDK.Lang.PushContext(".properties");

            this._info.SetProperties([
            new SDK.PluginProperty("group", "Firebase-config-setup-android"),
            path,
            android,
            new SDK.PluginProperty("group", "Firebase-config-setup-ios"),
            pathios,

            ]);

            this._info.AddCordovaPluginReference(
            {
                id: "cordova-plugin-firebasex",
                plugin: this,
                version: "11.0.3",
                variables: [
                        ["ANDROID_FIREBASE_CONFIG_FILEPATH", path],
                        ["ANDROID_FIREBASE_ANALYTICS_VERSION", android],
                        ["IOS_FIREBASE_CONFIG_FILEPATH", pathios]

                    ]
            });

            SDK.Lang.PopContext(); //.properties
            SDK.Lang.PopContext();
        }
    };

    PLUGIN_CLASS.Register(PLUGIN_ID, PLUGIN_CLASS);
}