"use strict";

{
	const C3 = self.C3;
	C3.Behaviors.Rex_boundary.Instance = class Rex_boundaryInstance extends C3.SDKBehaviorInstanceBase
	{
		constructor(behInst, properties)
		{
			super(behInst);
			if (properties)
			{
				this.mode = properties[0];
				this.alignMode = properties[1];
				this.horizontalEnable = (properties[2] == 1);
				this.horizontalBoundary = [properties[3], properties[4]];
				this.verticalEnable = (properties[5] == 1);
				this.verticalBoundary = [properties[6], properties[7]];
				sortBoundary(this.horizontalBoundary);
				sortBoundary(this.verticalBoundary);
				this.horizontalBoundInstInfo = {"uid":(-1), "p0":null, "p1":null};
				this.verticalBoundInstInfo = {"uid":(-1), "p0":null, "p1":null};
			}
			this._StartTicking();
		}
		Release()
		{
			super.Release();
		}
		updateH()
		{
			var instInfo = this.horizontalBoundInstInfo;
			var pin_inst = this._runtime.GetInstanceByUID(instInfo["uid"]);
			if (pin_inst == null)
				return;
			this.horizontalBoundary[0] = pin_inst.GetImagePoint(instInfo["p0"], true)[0];
			this.horizontalBoundary[1] = pin_inst.GetImagePoint(instInfo["p1"], true)[0];    
			sortBoundary(this.horizontalBoundary);
		};
		updateV()
		{
			var instInfo = this.verticalBoundInstInfo;
			var pin_inst = this._runtime.GetInstanceByUID(instInfo["uid"]);
			if (pin_inst == null)
				return;
			this.verticalBoundary[0] = pin_inst.GetImagePoint(instInfo["p0"], false)[1];
			this.verticalBoundary[1] = pin_inst.GetImagePoint(instInfo["p1"], false)[1];
			sortBoundary(this.verticalBoundary);
		};
		clampH()
		{
			if (!this.horizontalEnable)
				return false;
			
			var currentX = this._inst.GetWorldInfo().GetX();
			if (this.alignMode == 0)    // origin
			{
				// left
				if (this.isReachedBound(1))
				{
					this._inst.GetWorldInfo().SetX(this.horizontalBoundary[0]);
					this.Trigger(C3.Behaviors.Rex_boundary.Cnds.OnHitLeftBoundary);
				}
				// right
				else if (this.isReachedBound(2))
				{
					this._inst.GetWorldInfo().SetX(this.horizontalBoundary[1]);
					this.Trigger(C3.Behaviors.Rex_boundary.Cnds.OnHitRightBoundary);
				}
			}
			else    // boundaries
			{
				this._inst.GetWorldInfo()._UpdateBbox();
				const bbox = this._inst.GetWorldInfo().GetBoundingBox();
				// left	
				if (this.isReachedBound(1))
				{
					this._inst.GetWorldInfo().SetX(this.horizontalBoundary[0] + (this._inst.GetWorldInfo().GetX() - bbox.getLeft()));
					this.Trigger(C3.Behaviors.Rex_boundary.Cnds.OnHitLeftBoundary);
				}
				// right
				else if (this.isReachedBound(2))
				{
					this._inst.GetWorldInfo().SetX(this.horizontalBoundary[1] - (bbox.getRight() - this._inst.GetWorldInfo().GetX()));
					this.Trigger(C3.Behaviors.Rex_boundary.Cnds.OnHitRightBoundary);
				}
			}
			return (currentX != this._inst.GetWorldInfo().GetX());
		};
		clampV()
		{
			if (!this.verticalEnable)
				return false;
			
			var currentY = this._inst.GetWorldInfo().GetY();
			
			if (this.alignMode == 0)    // origin
			{
				// top
				if (this.isReachedBound(4))
				{
					this._inst.GetWorldInfo().SetY(this.verticalBoundary[0]);
					this.Trigger(C3.Behaviors.Rex_boundary.Cnds.OnHitTopBoundary);
				}
				// bottom
				else if (this.isReachedBound(8))
				{
					this._inst.GetWorldInfo().SetY(this.verticalBoundary[1]);
					this.Trigger(C3.Behaviors.Rex_boundary.Cnds.OnHitBottomBoundary);
				}
			}
			else    // boundaries
			{
				this._inst.GetWorldInfo()._UpdateBbox();
				const bbox = this._inst.GetWorldInfo().GetBoundingBox();
				// top
				if (this.isReachedBound(4))
				{
					this._inst.GetWorldInfo().SetY(this.verticalBoundary[0] + (this._inst.GetWorldInfo().GetY() - bbox.getTop()));
					this.Trigger(C3.Behaviors.Rex_boundary.Cnds.OnHitTopBoundary);
				}
				// bottom
				else if (this.isReachedBound(8))
				{
					this._inst.GetWorldInfo().SetY(this.verticalBoundary[1] - (bbox.getBottom() - this._inst.GetWorldInfo().GetY()));
					this.Trigger(C3.Behaviors.Rex_boundary.Cnds.OnHitBottomBoundary);
				}		
			}
			return (currentY != this._inst.GetWorldInfo().GetY());			
		};
		wrapH()
		{
			if (!this.horizontalEnable)
				return false;
			
			var currentX = this._inst.GetWorldInfo().GetX();
			
			if (this.alignMode == 0)    // origin
			{
				// left
				if (this.isReachedBound(1))
				{
					this._inst.GetWorldInfo().SetX(this.horizontalBoundary[1] + 1);
					this.Trigger(C3.Behaviors.Rex_boundary.Cnds.OnHitLeftBoundary);
				}
				// right
				else if (this.isReachedBound(2))
				{
					this._inst.GetWorldInfo().SetX(this.horizontalBoundary[0] - 1);
					this.Trigger(C3.Behaviors.Rex_boundary.Cnds.OnHitRightBoundary);
				}
			}
			else    // boundaries
			{
				this._inst.GetWorldInfo()._UpdateBbox();
				const bbox = this._inst.GetWorldInfo().GetBoundingBox();
				// left	
				if (this.isReachedBound(1))
				{
					this._inst.GetWorldInfo().SetX(this.horizontalBoundary[1] + 1 + (bbox.getRight() - this._inst.GetWorldInfo().GetX()));
					this.Trigger(C3.Behaviors.Rex_boundary.Cnds.OnHitLeftBoundary);
				}
				
				// right
				else if (this.isReachedBound(2))
				{
					this._inst.GetWorldInfo().SetX(this.horizontalBoundary[0] - 1 - (this._inst.GetWorldInfo().GetX() - bbox.getLeft()));
					this.Trigger(C3.Behaviors.Rex_boundary.Cnds.OnHitRightBoundary);
				}
			}
			return (currentX != this._inst.GetWorldInfo().GetX());
		};
		wrapV()
		{
			if (!this.verticalEnable)
				return false;
			
			var currentY = this._inst.GetWorldInfo().GetY();
			
			if (this.alignMode == 0)    // origin
			{
				// top
				if (this.isReachedBound(4))
				{
					this._inst.GetWorldInfo().SetY(this.verticalBoundary[1] + 1);
					this.Trigger(C3.Behaviors.Rex_boundary.Cnds.OnHitTopBoundary);
				}
				
				// bottom
				else if (this.isReachedBound(8))
				{
					this._inst.GetWorldInfo().SetY(this.verticalBoundary[0] - 1);
					this.Trigger(C3.Behaviors.Rex_boundary.Cnds.OnHitBottomBoundary);
				}
			}
			else    // boundaries
			{
				this._inst.GetWorldInfo()._UpdateBbox();
				const bbox = this._inst.GetWorldInfo().GetBoundingBox();
				// top	
				if (this.isReachedBound(4))
				{
					this._inst.GetWorldInfo().SetY(this.verticalBoundary[1] + 1 + (bbox.getBottom() - this._inst.GetWorldInfo().GetY()));
					this.Trigger(C3.Behaviors.Rex_boundary.Cnds.OnHitTopBoundary);
				}
				
				// bottom
				else if (this.isReachedBound(8))
				{
					this._inst.GetWorldInfo().SetY(this.verticalBoundary[0] - 1 - (this._inst.GetWorldInfo().GetY() - bbox.getTop()));
					this.Trigger(C3.Behaviors.Rex_boundary.Cnds.OnHitBottomBoundary);
				}		
			}
			return (currentY != this._inst.GetWorldInfo().GetY());			
		};
		modwrapH()
		{
			if (!this.horizontalEnable)
				return false;
			
			// mod wrap only support origin alignment
			var isReachedLeft = this.isReachedBound(1);
			var isReachedRight = this.isReachedBound(2);
			var isReached = (isReachedLeft || isReachedRight);
			
			if (isReached)
			{
				var dist = this.horizontalBoundary[1] - this.horizontalBoundary[0];
				var offset = (this._inst.GetWorldInfo().GetX() - this.horizontalBoundary[0]) % dist;
				if (offset < 0)
					offset += dist;
				
				this._inst.GetWorldInfo().SetX(offset + this.horizontalBoundary[0]);
			}
			
			if (isReachedLeft)
				this.Trigger(C3.Behaviors.Rex_boundary.Cnds.OnHitLeftBoundary);
			else if (isReachedRight)
				this.Trigger(C3.Behaviors.Rex_boundary.Cnds.OnHitRightBoundary);
				
			return isReached;
		};
		modwrapV()
		{
			if (!this.verticalEnable)
				return false;
				
			// mod wrap only support origin alignment		
			var isReachedTop = this.isReachedBound(4);
			var isReachedBottom = this.isReachedBound(8);
			var isReached = (isReachedTop || isReachedBottom);
			
			if (isReached)
			{
				var dist = this.verticalBoundary[1] - this.verticalBoundary[0];
				var offset = (this._inst.GetWorldInfo().GetY() - this.verticalBoundary[0]) % dist;
				if (offset < 0)
					offset += dist;
				
				this._inst.GetWorldInfo().SetY(offset + this.verticalBoundary[0]);
			}		

			if (isReachedTop)
				this.Trigger(C3.Behaviors.Rex_boundary.Cnds.OnHitTopBoundary);
			else if (isReachedBottom)
				this.Trigger(C3.Behaviors.Rex_boundary.Cnds.OnHitBottomBoundary);
						
			return isReached;			
		};
		isReachedBound(boundType)
		{
			this.updateH();
			this.updateV();
					
			var isReached = false;
			if (this.alignMode == 0) 
			{
				// left
				if ((boundType & 1) === 1)
					isReached |= (this._inst.GetWorldInfo().GetX() < this.horizontalBoundary[0]);
					
				// right
				if (((boundType>>1) & 1) === 1)
					isReached |=  (this._inst.GetWorldInfo().GetX() > this.horizontalBoundary[1]);
					
				// top
				if (((boundType>>2) & 1) === 1)
					isReached |=  (this._inst.GetWorldInfo().GetY() < this.verticalBoundary[0]);
					
				// bottom
				if (((boundType>>3) & 1) === 1)
					isReached |=  (this._inst.GetWorldInfo().GetY() > this.verticalBoundary[1]);
					
			}
			else
			{
				this._inst.GetWorldInfo()._UpdateBbox();
				const bbox = this._inst.GetWorldInfo().GetBoundingBox();
				if (this.mode === 0)
				{
					// left
					if ((boundType&1) === 1)
						isReached |= (bbox.getLeft() < this.horizontalBoundary[0]);
					
					// right
					if (((boundType>>1)&1) === 1)
						isReached |= (bbox.getRight() > this.horizontalBoundary[1]);
					
					// top
					if (((boundType>>2)&1) === 1)
						isReached |= (bbox.getTop() < this.verticalBoundary[0]);
					
					// bottom
					if (((boundType>>3)&1) === 1)
						isReached |= (bbox.getBottom() > this.verticalBoundary[1]);				
				}			
				else if ((this.mode === 1) || (this.mode === 2))
				{
					// left
					if ((boundType&1) === 1)
						isReached |= (bbox.getRight() < this.horizontalBoundary[0]);
					
					// right
					if (((boundType>>1)&1) === 1)
						isReached |= (bbox.getLeft() > this.horizontalBoundary[1]);
					
					// top
					if (((boundType>>2)&1) === 1)
						isReached |= (bbox.getBottom() < this.verticalBoundary[0]);
					
					// bottom
					if (((boundType>>3)&1) === 1)
						isReached |= (bbox.getTop() > this.verticalBoundary[1]);			
				}			
			}
			return isReached;
		};
		posX2percentage()
		{
			var instOffset, boundOffset;
			this.updateH();
			if (this.alignMode == 0)        
			{
				instOffset = this._inst.GetWorldInfo().GetX() - this.horizontalBoundary[0];
				boundOffset = this.horizontalBoundary[1] - this.horizontalBoundary[0];
			}
			else
			{
				this._inst.GetWorldInfo()._UpdateBbox();
				instOffset = this._inst.GetWorldInfo().GetBoundingBox().getLeft() - this.horizontalBoundary[0];
				boundOffset = this.horizontalBoundary[1] - this.horizontalBoundary[0] - (this._inst.GetWorldInfo().GetBoundingBox().getRight() - this._inst.GetWorldInfo().GetBoundingBox().getLeft());		
			}
			var pec = C3.clamp((instOffset/boundOffset), 0, 1);
			return pec;
		};
		posY2percentage()
		{
			var instOffset, boundOffset;
			this.updateV();
			if (this.alignMode == 0)        
			{		
				instOffset = this._inst.GetWorldInfo().GetY() - this.verticalBoundary[0];
				boundOffset = this.verticalBoundary[1] - this.verticalBoundary[0];
			}
			else
			{
				this._inst.GetWorldInfo()._UpdateBbox();
				instOffset = this._inst.GetWorldInfo().GetBoundingBox().getTop() - this.verticalBoundary[0];
				boundOffset = this.verticalBoundary[1] - this.verticalBoundary[0] - (this._inst.GetWorldInfo().GetBoundingBox().getBottom() - this._inst.GetWorldInfo().GetBoundingBox().getTop());				
			}
			var pec = C3.clamp((instOffset/boundOffset), 0, 1);
			return pec;
		};
		percentage2posX(p)
		{  
			p = C3.clamp(p, 0, 1);
			this.updateH();
			var rb, lb;
			if (this.alignMode == 0)    // origin
			{
				lb = this.horizontalBoundary[0];
				rb = this.horizontalBoundary[1];
			}
			else    // boundaries
			{
				this._inst.GetWorldInfo()._UpdateBbox();
				lb = this.horizontalBoundary[0] + (this._inst.GetWorldInfo().GetX() - this._inst.GetWorldInfo().GetBoundingBox().getLeft());
				rb = this.horizontalBoundary[1] - (this._inst.GetWorldInfo().GetBoundingBox().getRight() - this._inst.GetWorldInfo().GetX());
			}
			var x = lb + (rb - lb) * p;
			return x;
		};
		percentage2posY(p)
		{  
			p = C3.clamp(p, 0, 1);
			this.updateV();
			var bb, tb;
			if (this.alignMode == 0)    // origin
			{
				tb = this.verticalBoundary[0];
				bb = this.verticalBoundary[1];
			}
			else    // boundaries
			{
				this._inst.GetWorldInfo()._UpdateBbox();
				tb = this.verticalBoundary[0] + (this._inst.GetWorldInfo().GetY() - this._inst.GetWorldInfo().GetBoundingBox().getTop());
				bb = this.verticalBoundary[1] - (this._inst.GetWorldInfo().GetBoundingBox().getBottom() - this._inst.GetWorldInfo().GetY());
			}
			var y = tb + (bb - tb) * p;
			return y;
		};
		SaveToJson()
		{
			return {
				"he": this.horizontalEnable,
				"hb": this.horizontalBoundary,
				"ve": this.verticalEnable,
				"vb": this.verticalBoundary,
				"hp": clone(this.horizontalBoundInstInfo),
				"vp": clone(this.verticalBoundInstInfo)
			};
		}
		LoadFromJson(o)
		{
			this.activated = o["he"];
			this.horizontalBoundary = o["hb"];
			this.verticalEnable = o["ve"];
			this.verticalBoundary = o["vb"];
			this.horizontalBoundInstInfo = o["hp"];
			this.verticalBoundInstInfo = o["vp"];
		}
		Tick()
		{
			var isReachedHorizontal, isReachedVertical;
			if (this.mode == 0)
			{
				isReachedHorizontal = this.clampH();
				isReachedVertical = this.clampV();	
			}
			else if (this.mode == 1)
			{
				isReachedHorizontal = this.wrapH();
				isReachedVertical = this.wrapV();			
			}
			else if (this.mode == 2)
			{
				isReachedHorizontal = this.modwrapH();
				isReachedVertical = this.modwrapV();			
			}
			
			if (isReachedHorizontal || isReachedVertical)
			{                         
				this.Trigger(C3.Behaviors.Rex_boundary.Cnds.OnHitAnyBoundary);
				this._inst.GetWorldInfo().SetBboxChanged();			
			}
		}
		GetDebuggerProperties() {
            const prefix = "behaviors.rex_boundary";
            return [{
                title: "$" + this.GetBehaviorType().GetName(),
                properties: [{
                    name: "Horizontal",
                    value: this.horizontalBoundary[0] + "," + this.horizontalBoundary[1]
                }, {
                    name: "Vertical",
                    value: this.verticalBoundary[0] + "," + this.verticalBoundary[1]
                }]
            }]
        }
	};
}