"use strict";

{
	self.C3.Behaviors.Rex_boundary.Acts =
	{
		EnableHorizontal(s)
		{
			this.horizontalEnable = (s == 1);
		},
		EnableVertical(s)
		{
			this.verticalEnable = (s == 1);
		},
		SetHorizontalBoundary(l, r)
		{
			this.horizontalBoundary[0] = l;
			this.horizontalBoundary[1] = r;
			sortBoundary(this.horizontalBoundary);
			this.horizontalBoundInstInfo["uid"] = (-1);
		},
		SetVerticalBoundary(u, d)
		{
			this.verticalBoundary[0] = u;
			this.verticalBoundary[1] = d;
			sortBoundary(this.verticalBoundary);
			this.verticalBoundInstInfo["uid"] = (-1);
		},
		SetHorizontalBoundaryToObject(obj, leftImgpt, rightImgpt)
		{
			var instInfo = this.horizontalBoundInstInfo;
			instInfo["uid"] = obj.GetFirstPicked().GetUID();
			instInfo["p0"] = leftImgpt;
			instInfo["p1"] = rightImgpt;
		},
		SetVerticalBoundaryToObject(obj, topImgpt, bottomImgpt)
		{
			var instInfo = this.verticalBoundInstInfo;
			instInfo["uid"] = obj.GetFirstPicked().GetUID();
			instInfo["p0"] = topImgpt;
			instInfo["p1"] = bottomImgpt;
		},
		SetXByPercentage(p)
		{
			if (!this.horizontalEnable)
				return;
			var newX = this.percentage2posX(p);    
			if (newX !== this._inst.GetWorldInfo().GetX())
			{
				this._inst.GetWorldInfo().SetX(newX);
				this._inst.GetWorldInfo().SetBboxChanged();
			}
		},
		SetYByPercentage(p)
		{
			if (!this.verticalEnable)
				return;
			var newY = this.percentage2posY(p);
			if (newY !== this._inst.GetWorldInfo().GetY())
			{
				this._inst.GetWorldInfo().SetY(newY);
				this._inst.GetWorldInfo().SetBboxChanged();
			}
		},
		SetYXByPercentage(px, py)
		{
			var isXChanged = false;
			if (this.horizontalEnable)
			{
				this._inst.GetWorldInfo().SetX(this.percentage2posX(px));
				isXChanged = (newX !== this._inst.GetWorldInfo().GetX());
				if (isXChanged)
					this._inst.GetWorldInfo().SetX(newX);
			}
			var isYChanged = false;
			if (this.verticalEnable)
			{
				newY = this.percentage2posY(py); 
				isYChanged = (newY !== this._inst.GetWorldInfo().GetY());
				if (isYChanged)
					this._inst.GetWorldInfo().SetY(newY);
			}
			if (isXChanged || isYChanged)
			{
				this._inst.GetWorldInfo().SetBboxChanged();
			}
		}
	};
}