"use strict";
{
    C3.Plugins.EMI_INDO_inappbrowser.Instance = class NewPluginInstance extends C3.SDKInstanceBase
    {
        constructor(inst, properties)
        {
            super(inst);


            if (properties)
            {}

            this._Candition = C3.Plugins.EMI_INDO_inappbrowser.Cnds;

            if (typeof cordova == 'undefined')
            {
                return;
            }
            else
            {};

            var _inAppBrowser;

            const self = this;


            let openUrl = async(url, target, location) => {


                _inAppBrowser = window.cordova.InAppBrowser.open(url, this.setTarget(target), this.setLocation(location));


                _inAppBrowser.addEventListener('loadstop', (event) => {

                    self.Trigger(self._Candition.OnLoadStop);

                });

                _inAppBrowser.addEventListener('loadstart', (event) => {

                    self.Trigger(self._Candition.OnLoadStart);

                });

                _inAppBrowser.addEventListener('loaderror', (event) => {

                    self.Trigger(self._Candition.OnLoadError);

                });


                _inAppBrowser.addEventListener('exit', (event) => {

                    self.Trigger(self._Candition.OnExit);

                });


            }


            let show = async() => {

                _inAppBrowser.show()

            }


            let hide = async() => {

                _inAppBrowser.hide()

            }

            let exit = async() => {

                _inAppBrowser.close()

            }

            this.openUrl = openUrl;
            this.show = show;
            this.hide = hide;
            this.exit = exit;
        }

        Release()
        {
            super.Release();
        }

        SaveToJson()
        {
            return {
                // data to be saved for savegames
            };
        }

        LoadFromJson(o)
        {

            }

        setTarget(_index)
        {
            switch (_index)
            {
                case 0:
                    return "_self";
                case 1:
                    return "_blank";
                case 2:
                    return "_system";
            }
        }

        setLocation(_index)
        {
            switch (_index)
            {
                case 0:
                    return "location=yes";
                case 1:
                    return "location=no";
            }
        }

        GetDebuggerProperties()
        {
            return [
            {
                title: "NewPlugin",
                properties: [
                    //{name: ".current-animation",	value: this._currentAnimation.GetName(),	onedit: v => this.CallAction(Acts.SetAnim, v, 0) },
                ]
            }];
        }
    };
}