"use strict";
{
    C3.Plugins.skymen_RunInBackground.Instance = class RunInBackgroundInstance extends C3.SDKInstanceBase
    {
        constructor(inst, properties)
        {
            super(inst);

            this.runInBackground = false;
            this.suspendInterval = false;

            if (properties)
            {
                this.runInBackground = properties[0]
            }
            this._runtime._dispatcher.addEventListener("suspend", () => {
                this.UpdateState();
            })
            this._runtime._dispatcher.addEventListener("resume", () => {
                this.UpdateState();
            })
        }

        Release()
        {
            super.Release();
        }

        UpdateState()
        {
            if (this._runtime.IsSuspended())
            {
                if (this.runInBackground && !this.suspendInterval)
                {
                    this.suspendInterval = setInterval(() => {
                        this._runtime.Tick(null, false, "background-wake");
                    }, 1000 / 60)
                }
                if (this.suspendInterval && !this.runInBackground)
                {
                    clearInterval(this.suspendInterval);
                    this.suspendInterval = false;
                }
            }
            else
            {
                if (this.suspendInterval)
                {
                    clearInterval(this.suspendInterval);
                    this.suspendInterval = false;
                }
            }
        }

        SaveToJson()
        {
            return {
                // data to be saved for savegames
            };
        }

        LoadFromJson(o)
        {
            // load state for savegames
        }

        GetDebuggerProperties()
        {
            return [
            {
                title: "RunInBackground",
                properties: [
                    //{name: ".current-animation",	value: this._currentAnimation.GetName(),	onedit: v => this.CallAction(Acts.SetAnim, v, 0) },
                ]
            }];
        }
    };
}