﻿/////////////////////////////////////////////////////////
// SkendPow effect
varying mediump vec2 vTex;
uniform lowp sampler2D samplerFront;

uniform lowp float pixelWidth;
uniform lowp float pixelHeight;
uniform lowp float Skend;
uniform lowp float Power;
uniform lowp float Angle;
uniform lowp float ObjectAngle;
uniform mediump vec2 pixelSize;
uniform mediump vec2 srcEnd;
uniform mediump vec2 srcStart;
uniform mediump vec2 srcOriginStart;
uniform mediump vec2 srcOriginEnd;
uniform mediump vec2 layoutStart;
uniform mediump vec2 layoutEnd;
uniform mediump float layerAngle;

#define PI 3.14159265

void main(void)
{	
	mediump vec2 n = (vTex - srcOriginStart) / (srcOriginEnd - srcOriginStart);
	lowp float invertY = (srcOriginEnd.y < srcOriginStart.y) ? 1.0 : 0.0;
	lowp float radAngle = Angle/-180.0*PI + ObjectAngle/-180.0*PI*invertY;
    mediump vec2 layoutSize = abs(vec2(layoutEnd.x-layoutStart.x,(layoutEnd.y-layoutStart.y))); 
    mediump vec2 texelSize = abs(srcOriginEnd-srcOriginStart)/layoutSize;
	lowp float dist = sqrt(pow(cos(radAngle) * n.x, 2.0) + pow(sin(radAngle) * n.y, 2.0));
	lowp float distX = dist;
	lowp float distY = dist;
	if (cos(radAngle) < 0.0) distY = 1.0 - abs(dist);
	if (sin(radAngle) > 0.0) distX = 1.0 - abs(dist);
	n.y -= cos(radAngle) * (texelSize.y*Skend)*pow(distY,Power);
	n.x -= sin(radAngle) * (texelSize.x*Skend)*pow(distX,Power);
	n.y = clamp(n.y, 0.0, 1.0);
	n.x = clamp(n.x, 0.0, 1.0);
		
	gl_FragColor = texture2D(samplerFront,mix(srcOriginStart, srcOriginEnd, n));
}