﻿// ECMAScript 5 strict mode
"use strict";

assert2(cr, "cr namespace not created");
assert2(cr.plugins_, "cr.plugins_ not created");

/////////////////////////////////////
// Plugin class

cr.plugins_.Greenworks_Redraw = function(runtime)
{
	this.runtime = runtime;
};

(function ()
{
	///////////////////////////////////////
    ///////////////////////////////////////
	var pluginProto = cr.plugins_.Greenworks_Redraw.prototype;
		
	/////////////////////////////////////
	// Object type class
	pluginProto.Type = function(plugin)
	{
		this.plugin = plugin;
		this.runtime = plugin.runtime;
	};

	var typeProto = pluginProto.Type.prototype;

	// called on startup for each object type
	typeProto.onCreate = function()
	{
	};
	/////////////////////////////////////
	// Instance class
	pluginProto.Instance = function(type)
	{
		this.type = type;
		this.runtime = type.runtime;
		$('html').css({'height':"100vh"});
		$('body').css({'height':"100vh"});
	};

	var instanceProto = pluginProto.Instance.prototype;

	// called whenever an instance is created
	instanceProto.onCreate = function()
	{
		this.wait = this.properties[1];
		this.keepRedraw = this.properties[2] === 0;
		if (this.keepRedraw) this.redraw();
	};

	// called whenever an instance is created
	instanceProto.checkKeepRedraw = function(nbFrames)
	{
		if (!this.keepRedraw) return;
		if (nbFrames <= 0) this.redraw();
		else requestAnimationFrame(this.checkKeepRedraw.bind(this, nbFrames-1));
	};

	// called whenever an instance is destroyed
	// note the runtime may keep the object after this call for recycling; be sure
	// to release/recycle/reset any references to other objects in this function.
	instanceProto.onDestroy = function ()
	{
	};

	instanceProto.redraw = function ()
	{
		$('body').css({'opacity':0.999});

		var self = this;
		requestAnimationFrame(function()
        {
			$('body').css({'opacity':1});
			self.checkKeepRedraw(self.wait);
        });
	};

	//////////////////////////////////////

	// Conditions
	function Cnds() {};



	pluginProto.cnds = new Cnds();

	//////////////////////////////////////
	// Actions
	function Acts() {};

    Acts.prototype.RedrawBrowser = function()
    {
		//Prevent starting a new force render loop if one is already running
		if (!this.keepRedraw) this.redraw();
	};

    Acts.prototype.RedrawBrowserPeriod = function(period)
    {
		//Prevent starting a new force render loop if one is already running
		if (this.keepRedraw) return;
		this.keepRedraw = true;
		this.redraw();
        setTimeout(function()
        {
            this.keepRedraw = false;
        }, period * 1000);
	};

	Acts.prototype.RedrawBrowserActivate = function() {
		//Prevent starting a new force render loop if one is already running
		if (this.keepRedraw) return;
		this.keepRedraw = true;
		this.redraw();
	};
	Acts.prototype.RedrawBrowserDeactivate = function() {
		this.keepRedraw = false;
	};
	Acts.prototype.SetRedrawWait = function(wait) {
		this.wait = wait;
	};


	pluginProto.acts = new Acts();
	
	//////////////////////////////////////
	// Expressions
	function Exps() {};


    pluginProto.exps = new Exps();


}());