﻿var version = "1.2";

function GetPluginSettings()
{
	return {
		"name":			"Greenworks_Redraw",
		"id":			"Greenworks_Redraw",
		"version":		version,
		"description":	"Various functions to force workspace redrawing.",
		"author":		"Toby R, Skymen",
		"help url":		"https://www.construct.net/fr/forum/construct-2/general-discussion-17/big-nw-js-roundup-news-tips-119428",
		"category":		"Platform specific",
		"type":			"object",
		"rotatable":	false,
		"flags":		pf_singleglobal,
	};
};

////////////////////////////////////////

////////////////////////////////////////
// Actions
AddAction(0, 0, "Redraw browser window", "General", "Redraw browser window", "Force browser window to redraw once.", "RedrawBrowser");

AddNumberParam("Period", "The period of force rendering in seconds", 5);
AddAction(1, 0, "Redraw browser period", "General", "Redraw browser for {0}s", "Force browser window to redraw for next X seconds.", "RedrawBrowserPeriod");

AddAction(2, 0, "Activate constant redraw", "General", "Constant redraw activated", "Force browser window to redraw until deactivated.", "RedrawBrowserActivate");

AddAction(3, 0, "Deactivate constant redraw", "General", "Constant redraw deactivated", "Stop browser window from force redrawing.", "RedrawBrowserDeactivate");

AddNumberParam("Wait", "The number of ticks to wait before the next redraw", 1);
AddAction(4, 0, "Set redraw wait", "General", "Set redraw wait to {0} ticks", "Change the value of the redraw wait", "SetRedrawWait");


////////////////////////////////////////
ACESDone();

////////////////////////////////////////
// Properties
var property_list = [
	new cr.Property(ept_text, "Version " + version, "", "", "", true),
	new cr.Property(ept_integer, "Redraw wait", 1, "Number of ticks before the next redraw."),
	new cr.Property(ept_combo, "Auto Redraw", "No", "Start constant redraw immediately", "Yes|No")
	];

// Called by IDE when a new object type is to be created
function CreateIDEObjectType()
{
	return new IDEObjectType();
}

// Class representing an object type in the IDE
function IDEObjectType()
{
	assert2(this instanceof arguments.callee, "Constructor called as a function");
}

// Called by IDE when a new object instance of this type is to be created
IDEObjectType.prototype.CreateInstance = function(instance)
{
	return new IDEInstance(instance);
}

// Class representing an individual instance of an object in the IDE
function IDEInstance(instance, type)
{
	assert2(this instanceof arguments.callee, "Constructor called as a function");
	
	// Save the constructor parameters
	this.instance = instance;
	this.type = type;
	
	// Set the default property values from the property table
	this.properties = {};
	
	for (var i = 0; i < property_list.length; i++)
		this.properties[property_list[i].name] = property_list[i].initial_value;
		
	// Plugin-specific variables
	// this.myValue = 0...
}

// Called when inserted via Insert Object Dialog for the first time
IDEInstance.prototype.OnInserted = function()
{
}

// Called when double clicked in layout
IDEInstance.prototype.OnDoubleClicked = function()
{
}

// Called after a property has been changed in the properties bar
IDEInstance.prototype.OnPropertyChanged = function(property_name)
{
}

// For rendered objects to load fonts or textures
IDEInstance.prototype.OnRendererInit = function(renderer)
{
}

// Called to draw self in the editor if a layout object
IDEInstance.prototype.Draw = function(renderer)
{
}

// For rendered objects to release fonts or textures
IDEInstance.prototype.OnRendererReleased = function(renderer)
{
}