"use strict";
{
  const C3 = self.C3;
  C3.Behaviors.SkymenSkin.Instance = class SkymenSkinInstance extends (
    C3.SDKBehaviorInstanceBase
  ) {
    //SDKInstanceBase
    constructor(inst, properties) {
      super(inst);
      // Load properties
      this.skinBaseTag = properties[0];

      // object is sealed after this call, so make sure any properties you'll ever need are created, e.g.
      if (C3.SkymenSkinCore == undefined) {
        alert("Skin base plugin needed, please create it.");
      } else if (C3.SkymenSkinCore[this.skinBaseTag] == undefined) {
        alert("Skin base with tag " + this.skinBaseTag + " cannot be found.");
      } else {
        this.skinBase = C3.SkymenSkinCore[this.skinBaseTag];
        this.skinBase.addInstance(this);
      }

      //Properties ======
      this.skinTag = properties[1];
      this.subSkinTag = properties[2];
      this.oldSkinTag = properties[1];
      this.oldSubSkinTag = properties[2];
      this.syncWithAnim = properties[3] === 0 || properties[3] === 2;
      this.syncWithFrame = properties[3] === 1 || properties[3] === 2;
      this.default = properties[4] === 0; //0 = Yes, 1 = No
      this.hideDefault = properties[5] === 0; //0 = Yes, 1 = No
      this.imagePoint = properties[6];
      this.syncZOrder = properties[7] === 0; //0 = Yes, 1 = No
      this.syncSize = properties[8] === 1;
      this.syncScale = properties[8] === 2;
      this.firstFrame = true;
      this.widthRatio = 1;
      this.heightRatio = 1;
      this.lastLayout = this._runtime.running_layout;

      //Object
      this.object = null;
      if (!this._inst.behaviorSkins) {
        this._inst.behaviorSkins = [];
      }
      var found = false;

      for (let index = 0; index < this._inst.behaviorSkins.length; index++) {
        const behavior = this._inst.behaviorSkins[index];
        if (this === behavior) {
          found = true;
          this.behaviorId = index;
        }
      }

      if (!found) {
        this.behaviorId = this._inst.behaviorSkins.length;
        this._inst.behaviorSkins.push(this);
      }

      //Init
      if (this.skinBase.init) {
        this.updateSkin();
      }

      this._StartTicking2();
    }

    SaveToJSON() {
      return {
        skinTag: this.skinTag,
        subSkinTag: this.subSkinTag,
        oldSkinTag: this.oldSkinTag,
        oldSubSkinTag: this.oldSubSkinTag,
        syncWithAnim: this.syncWithAnim,
        syncWithFrame: this.syncWithFrame,
        default: this.default,
        hideDefault: this.hideDefault,
        imagePoint: this.imagePoint,
        syncZOrder: this.syncZOrder,
        syncSize: this.syncSize,
        syncScale: this.syncScale,
        firstFrame: this.firstFrame,
        skinBaseTag: this.skinBaseTag,
        behaviorId: this.behaviorId,
      };
    }

    LoadToJSON(o) {
      this.skinTag = o.skinTag;
      this.subSkinTag = o.subSkinTag;
      this.oldSkinTag = o.oldSkinTag;
      this.oldSubSkinTag = o.oldSubSkinTag;
      this.syncWithAnim = o.syncWithAnim;
      this.syncWithFrame = o.syncWithFrame;
      this.default = o.default;
      this.hideDefault = o.hideDefault;
      this.imagePoint = o.imagePoint;
      this.syncZOrder = o.syncZOrder;
      this.firstFrame = o.firstFrame;
      this.skinBaseTag = o.skinBaseTag;
      this.behaviorId = o.behaviorId;
      this.syncSize = o.syncSize;
      this.syncScale = o.syncScale;
    }

    Tick() {
      if (this.firstFrame) {
        if (this.syncWithAnim) {
          this.subSkinTag = this.getCurAnim(this._inst);
          this.oldsubSkinTag = this.getCurAnim(this._inst);
        }
        this.firstFrame = false;
      }
      this._StopTicking();
    }

    Tick2() {
      if (this.object == null) return;
      var [newx, newy] = this._inst.GetImagePoint(this.imagePoint);
      var worldInfo = this.GetWorldInfo();
      var objectWorldInfo = this.object.GetWorldInfo();

      var angle = worldInfo.GetAngle();
      var inst = {
        angle: worldInfo.GetAngle(),
        x: worldInfo.GetX(),
        y: worldInfo.GetY(),
        width: worldInfo.GetWidth(),
        height: worldInfo.GetHeight(),
      };

      var object = {
        angle: objectWorldInfo.GetAngle(),
        x: objectWorldInfo.GetX(),
        y: objectWorldInfo.GetY(),
        width: objectWorldInfo.GetWidth(),
        height: objectWorldInfo.GetHeight(),
      };

      var anim = this.getCurAnim(this._inst);

      if (this.syncSize || this.syncScale) {
        if (object.width != inst.width * this.widthRatio) {
          objectWorldInfo.SetWidth(inst.width * this.widthRatio);
        }

        if (object.height != inst.height * this.heightRatio) {
          objectWorldInfo.SetHeight(inst.height * this.heightRatio);
        }
      } else {
        var mirrorred = inst.width < 0;
        var selfMirrorred = object.width < 0;
        var flipped = inst.height < 0;
        var selfFlipped = object.height < 0;

        if (mirrorred != selfMirrorred) {
          objectWorldInfo.SetWidth(
            Math.abs(object.width) * (mirrorred ? -1 : 1)
          );
        }

        if (flipped != selfFlipped) {
          objectWorldInfo.SetHeight(
            Math.abs(object.height) * (flipped ? -1 : 1)
          );
        }
      }

      var other = this._inst;
      if (this.behaviorId != 0) {
        var i = this.behaviorId - 1;
        while (i >= 0 && this._inst.behaviorSkins[i].object == null) {
          i--;
        }
        if (i >= 0) {
          other = this._inst.behaviorSkins[i].object;
        }
      }

      if (
        this.syncZOrder &&
        objectWorldInfo.GetZIndex() !== other.GetWorldInfo().GetZIndex() + 1
      ) {
        this.setZorder();
      }

      if (object.x != newx) {
        objectWorldInfo.SetX(newx);
      }

      if (object.y != newy) {
        objectWorldInfo.SetY(newy);
      }

      if (object.angle != angle) {
        objectWorldInfo.SetAngle(angle);
      }

      objectWorldInfo.SetBboxChanged();

      if (this.syncWithAnim && this.subSkinTag != anim) {
        this.subSkinTag = anim;
      }

      if (
        this.syncWithFrame &&
        this._inst._sdkInst._currentFrameIndex !=
          this.object._sdkInst._currentFrameIndex
      ) {
        this.object._sdkInst.CallAction(
          C3.Plugins.Sprite.Acts.SetAnimFrame,
          this._inst._sdkInst._currentFrameIndex
        );
      }

      if (
        this.skinTag != this.oldSkinTag ||
        this.subSkinTag != this.oldSubSkinTag
      ) {
        this.oldSkinTag = this.skinTag;
        this.oldSubSkinTag = this.subSkinTag;
        this.updateSkin();
      }
    }

    Release() {
      super.Release();
    }

    updateSkin() {
      if (this._inst._sdkInst == null) return;

      var instInfo = this._inst.GetWorldInfo();

      if (this.default) {
        if (this.object != null) {
          this.destroy();
        }
        if (this.hideDefault && !instInfo.IsVisible()) {
          instInfo.SetVisible(true);
          this._runtime.UpdateRender();
        }
        return;
      } else {
        if (this.hideDefault && instInfo.IsVisible()) {
          instInfo.SetVisible(false);
          this._runtime.UpdateRender();
        }
      }

      if (this.object == null) {
        if (this._inst && this._inst._sdkInst._currentAnimation) {
          var anim = this.getCurAnim(this._inst);
          if (this.syncWithAnim && this.subSkinTag != anim) {
            this.subSkinTag = anim;
          }
        }
        var type = this.getType(this.skinTag, this.subSkinTag);
        if (type == null) {
          console.warn(
            "Cannot assign subskin " +
              this.subSkinTag +
              " of skin " +
              this.skinTag +
              " because it doesn't exist. Reverting back to default."
          );
          this.default = true;
          this.updateSkin();
          return;
        }
        if (this.syncWithAnim) {
          this.subSkinTag = this.getCurAnim(this._inst);
        }
        var [x, y] = this._inst.GetImagePoint(this.imagePoint);
        this.object = this._runtime.CreateInstance(
          type,
          this._inst.GetWorldInfo().GetLayer(),
          x,
          y
        );
        var objectInfo = this.object.GetWorldInfo();
        if (this.syncScale) {
          let defaultAnim = this._inst._sdkInst._objectClass._animations.find(
            (x) =>
              x._name ===
              this._inst._sdkInst._objectClass._defaultInstanceData[5][1]
          );
          defaultAnim =
            defaultAnim || this._inst._sdkInst._objectClass._animations[0];
          this.widthRatio =
            ((((objectInfo.GetWidth() / Math.abs(instInfo.GetWidth())) * //Sign in case object is mirrorred
              this._inst._sdkInst._objectClass._defaultInstanceData[0][3]) /
              defaultAnim._frames[0]._imageInfo._width) * //Ratio of image size to default size
              this._inst._sdkInst._currentAnimation._frames[0]._imageInfo
                ._width) /
            instInfo.GetWidth(); //Ratio of frame size to object size

          this.heightRatio =
            ((((objectInfo.GetHeight() / Math.abs(instInfo.GetHeight())) *
              this._inst._sdkInst._objectClass._defaultInstanceData[0][4]) /
              defaultAnim._frames[0]._imageInfo._height) *
              this._inst._sdkInst._currentAnimation._frames[0]._imageInfo
                ._height) /
            instInfo.GetHeight();
        } else if (this.syncSize) {
          this.widthRatio = 1;
          this.heightRatio = 1;
          objectInfo.SetWidth(instInfo.GetWidth());
          objectInfo.SetHeight(instInfo.GetHeight());
        }
        var anim = this.getAnim(this.skinTag, this.subSkinTag);
        this.object._sdkInst.CallAction(
          C3.Plugins.Sprite.Acts.SetAnim,
          anim,
          0
        );
        if (this.syncWithFrame) {
          this.object._sdkInst.CallAction(
            C3.Plugins.Sprite.Acts.SetAnimSpeed,
            0
          );
        }
        this.setZorder();
        this.object._sdkInst.CallAction(
          C3.Plugins.Sprite.Acts.SetCollisions,
          0
        );
      } else {
        if (
          this.object.GetObjectClass() ==
          this.getType(this.skinTag, this.subSkinTag)
        ) {
          if (this.syncWithAnim) {
            this.subSkinTag = this.getCurAnim(this._inst);
          }
          anim = this.getAnim(this.skinTag, this.subSkinTag);
          this.object._sdkInst.CallAction(
            C3.Plugins.Sprite.Acts.SetAnim,
            anim,
            0
          );
          if (this.syncWithFrame) {
            this.object._sdkInst.CallAction(
              C3.Plugins.Sprite.Acts.SetAnimSpeed,
              0
            );
          }
          if (this.syncZOrder) this.setZorder();
          this.object._sdkInst.CallAction(
            C3.Plugins.Sprite.Acts.SetCollisions,
            0
          );
        } else {
          this.destroy();
          this.updateSkin();
          return;
        }
      }
    }

    destroy() {
      if (this.object === null) return;
      if (this.object.behaviorSkins) {
        for (var i = 0; i < this.object.behaviorSkins.length; i++) {
          this.object.behaviorSkins[i].destroy();
        }
      }
      this._runtime.DestroyInstance(this.object);
      this.object = null;
    }

    setZorder() {
      var other = this._inst;

      //You can layer multiple skins addons on top of each other and their z order
      //will order in the order you set them in the editor from top to bottom.
      //If this is not the first behavior, get the behavior below it to give you the object to be on top of.
      //If the behavior below doesn't have an active skin, just go the one below etc

      if (this.behaviorId != 0) {
        var i = this.behaviorId - 1;
        while (i >= 0 && this._inst.behaviorSkins[i].object == null) {
          i--;
        }
        if (i >= 0) {
          other = this._inst.behaviorSkins[i].object;
        }
      }

      //Once you get the "other" instance, just get the info, and change the z order.

      var otherInfo = other.GetWorldInfo();
      var objectInfo = this.object.GetWorldInfo();

      var objectLayer = objectInfo.GetLayer();
      var otherLayer = otherInfo.GetLayer();

      // And this is the part I copied from the system action's code
      // First move to same layer as other object if different
      if (objectLayer.GetIndex() !== otherLayer.GetIndex()) {
        objectLayer._RemoveInstance(this.object, true);
        objectInfo._SetLayer(otherLayer);
        otherLayer._AddInstance(this.object, true);
        objectLayer = objectInfo.GetLayer();
      }
      objectLayer.MoveInstanceAdjacent(this.object, other, true);
      this._runtime.UpdateRender();
    }

    getType(skin, subSkin) {
      if (
        this.skinBase.skins[skin] == undefined ||
        this.skinBase.skins[skin][subSkin] == undefined
      ) {
        return null;
      }
      return this.skinBase.skins[skin][subSkin].type;
    }

    getAnim(skin, subSkin) {
      if (
        this.skinBase.skins[skin] == undefined ||
        this.skinBase.skins[skin][subSkin] == undefined
      ) {
        return null;
      }
      return this.skinBase.skins[skin][subSkin].anim;
    }

    getCurAnim(obj) {
      return obj._sdkInst._currentAnimation.GetName();
    }
  };
}
