"use strict";
{

    const PLUGIN_ID = "Mikal_GithubLink";
    const PLUGIN_VERSION = "1.0.0.0";
    const PLUGIN_CATEGORY = "other";

    const PLUGIN_CLASS = SDK.Plugins.Mikal_GithubLink = class GithubLinkPlugin extends SDK.IPluginBase
    {
        constructor()
        {
            super(PLUGIN_ID);

            SDK.Lang.PushContext("plugins." + PLUGIN_ID.toLowerCase());

            this._info.SetName(lang(".name"));
            this._info.SetDescription(lang(".description"));
            this._info.SetVersion(PLUGIN_VERSION);
            this._info.SetCategory(PLUGIN_CATEGORY);
            this._info.SetAuthor("Mikal");
            this._info.SetHelpUrl(lang(".help-url"));
            this._info.SetIsSingleGlobal(true);
            // this._info.SetPluginType("world");			// mark as world plugin, which can draw

            this._info.SetSupportedRuntimes(["c3"]);

            SDK.Lang.PushContext(".properties");

            this._info.SetProperties([
                new SDK.PluginProperty("text", "github-link", ""),
                new SDK.PluginProperty("link", "launch-github",
            {
                linkCallback: function(sdkInst)
                {
                    window.open("x-github-client://openRepo/" + globalThis._Mikal_GithubLinkURL);
                },
                callbackType: "once-for-type"
            }),
            ]);

            SDK.Lang.PopContext(); //.properties
            SDK.Lang.PopContext();
        }
    };

    PLUGIN_CLASS.Register(PLUGIN_ID, PLUGIN_CLASS);
}