uniform lowp float horizontalScale;

/////////////////////////////////////////////////////////
// BigBlur

//The current foreground texture co-ordinate
varying mediump vec2 vTex;
//The foreground texture sampler, to be sampled at vTex
uniform lowp sampler2D samplerFront;
//The current foreground rectangle being rendered
uniform mediump vec2 srcStart;
uniform mediump vec2 srcEnd;
//The current foreground source rectangle being rendered
uniform mediump vec2 srcOriginStart;
uniform mediump vec2 srcOriginEnd;
//The current foreground source rectangle being rendered, in layout 
uniform mediump vec2 layoutStart;
uniform mediump vec2 layoutEnd;
//The background texture sampler used for background - blending effects
uniform lowp sampler2D samplerBack;
//The current background rectangle being rendered to, in texture co-ordinates, for background-blending effects
uniform mediump vec2 destStart;
uniform mediump vec2 destEnd;
//The time in seconds since the runtime started. This can be used for animated effects
uniform mediump float seconds;
//The size of a texel in the foreground texture in texture co-ordinates
uniform mediump vec2 pixelSize;
//The current layer scale as a factor (i.e. 1 is unscaled)
uniform mediump float layerScale;
//The current layer angle in radians.
uniform mediump float layerAngle;

mediump float pixelWidth = pixelSize.x;
mediump float halfPixelWidth = pixelWidth / 2.0;
mediump float realSize = pixelWidth * horizontalScale;

lowp vec4 addBlur( mediump float pos, mediump float alpha) {
	mediump vec2 newTex = vTex + vec2(pos * realSize, halfPixelWidth);
	newTex.x = clamp(newTex.x,min(srcOriginStart.x, srcOriginEnd.x),max(srcOriginStart.x, srcOriginEnd.x));
	newTex.y = clamp(newTex.y,min(srcOriginStart.y, srcOriginEnd.y),max(srcOriginStart.y, srcOriginEnd.y));
	return texture2D(samplerFront, newTex) * alpha;
//	return texture2D(samplerFront, clamp(vTex + vec2(pos * realSize, halfPixelWidth),srcOriginStart,srcOriginEnd)) * alpha;
}

void main(void) {
	lowp vec4 front = texture2D(samplerFront, vTex) * 0.0867265826959637;
	front += addBlur(-10., 0.00816463058748422);
	front += addBlur(-9., 0.0127913835543763);
	front += addBlur(-8., 0.0191149950404317);
	front += addBlur(-7., 0.0272462378692536);
	front += addBlur(-6., 0.0370437192544233);
	front += addBlur(-5., 0.0480394814107598);
	front += addBlur(-4., 0.0594234309266334);
	front += addBlur(-3., 0.0701120751911035);
	front += addBlur(-2., 0.07890483324789);
	front += addBlur(-1., 0.084701300241491);
	front += addBlur(1., 0.084701300241491);
	front += addBlur(2., 0.07890483324789);
	front += addBlur(3., 0.0701120751911035);
	front += addBlur(4., 0.0594234309266334);
	front += addBlur(5., 0.0480394814107598);
	front += addBlur(6., 0.0370437192544233);
	front += addBlur(7., 0.0272462378692536);
	front += addBlur(8., 0.0191149950404317);
	front += addBlur(9., 0.0127913835543763);
	front += addBlur(10., 0.00816463058748422);

	gl_FragColor = front;
}