precision mediump float;

uniform lowp float scale;
uniform lowp float timeSpeed;
uniform lowp float directionScale;
uniform lowp float distortionScale;
uniform lowp float colorR;
uniform lowp float colorG;
uniform lowp float colorB;

/////////////////////////////////////////////////////////
// CausticWave

//The current foreground texture co-ordinate
varying mediump vec2 vTex;
//The foreground texture sampler, to be sampled at vTex
uniform lowp sampler2D samplerFront;
//The current foreground rectangle being rendered
uniform mediump vec2 srcStart;
uniform mediump vec2 srcEnd;
//The current foreground source rectangle being rendered
uniform mediump vec2 srcOriginStart;
uniform mediump vec2 srcOriginEnd;
//The current foreground source rectangle being rendered, in layout 
uniform mediump vec2 layoutStart;
uniform mediump vec2 layoutEnd;
//The background texture sampler used for background - blending effects
uniform lowp sampler2D samplerBack;
//The current background rectangle being rendered to, in texture co-ordinates, for background-blending effects
uniform mediump vec2 destStart;
uniform mediump vec2 destEnd;
//The time in seconds since the runtime started. This can be used for animated effects
uniform mediump float seconds;
//The size of a texel in the foreground texture in texture co-ordinates
uniform mediump vec2 pixelSize;
//The current layer scale as a factor (i.e. 1 is unscaled)
uniform mediump float layerScale;
//The current layer angle in radians.
uniform mediump float layerAngle;

float randomVal (float inVal)
{
    return fract(sin(dot(vec2(inVal, 2523.2361) ,vec2(12.9898,78.233))) * 43758.5453)-0.5;
}

vec2 randomVec2 (float inVal)
{
    return normalize(vec2(randomVal(inVal), randomVal(inVal+151.523)));
}

float makeWaves(vec2 uv, float theTime, float offset)
{
    float result = 0.0;
    float direction = 0.0;
    float sineWave = 0.0;
    vec2 randVec = vec2(1.0,0.0);
    float i;
    for(int n = 0; n < 16; n++)
    {
        i = float(n)+offset;
        randVec = randomVec2(float(i));
        // direction = (uv.x*randVec.x+uv.y*randVec.y);
        direction = directionScale*(uv.x*randVec.x+uv.y*randVec.y);
        sineWave = sin(direction*randomVal(i+1.6516)+theTime*timeSpeed);
        sineWave = smoothstep(0.0,1.0,sineWave);
    	result += randomVal(i+123.0)*sineWave;
    }
    return result;
}

void main()
{
    // Normalzie for spritesheets
    vec2 n = (vTex - srcOriginStart) / (srcOriginEnd-srcOriginStart);
    //	vec2 uv = vTex / (1.0/pixelSize.x);
	  vec2 uv = n;
    
    vec2 uv2 = uv * scale; // scale
    
    // uv *= 2.0;
    /*
    uv2 *= (0.9+iMouse.y*0.01);
    uv *= (0.9+iMouse.y*0.01);
	*/
    
    float result = 0.0;
    float result2 = 0.0;
    
    result = makeWaves( uv2+vec2(seconds*timeSpeed,0.0), seconds, 0.1);
    result2 = makeWaves( uv2-vec2(seconds*0.8*timeSpeed,0.0), seconds*0.8+0.06, 0.26);
    
    //result *= 2.6;
    
    result = smoothstep(0.4,1.1,1.0-abs(result));
    result2 = smoothstep(0.4,1.1,1.0-abs(result2));
    
    result = 2.0*smoothstep(0.35,1.8,(result+result2)*0.5);
    
	//fragColor = vec4(result)*0.7+texture( iChannel0 , uv );
    
    // thank for this code below Shane!
    vec2 p = vec2(result, result2)*.015 + sin(uv*16. - cos(uv.yx*16. + seconds*timeSpeed))*.015; // Etc.
    p = p * distortionScale;
	gl_FragColor = vec4(result)*0.7*vec4(colorR, colorG, colorB, 1.0) +texture2D( samplerFront , (uv + p) * (srcOriginEnd-srcOriginStart) + srcOriginStart );
}
