"use strict";
{
    C3.Plugins.Mikal_ElementQuad.Instance = class ElementQuadInstance extends C3.SDKWorldInstanceBase
    {
        constructor(inst, properties)
        {
            super(inst);


            if (properties)
            {
            }
            this._elementId = ""
            this._elementTexture = null
            this._newElementId = false
        }

        Release()
        {
            super.Release();
        }

        Draw(renderer)
        {
            if (this._elementId == "") return; // elementID not set, can't draw the element

            var myCanvas = document.getElementById(this._elementId)
            // Create texture if it does not exist (could this be done in constructor?)
            if (this._elementTexture === null || this._newElementId)
            {
                if(this._elementTexture !== null)
                {
                    renderer.DeleteTexture(this._elementTexture)
                }
                this._newElementId = false
                this._elementTexture = renderer.CreateDynamicTexture(myCanvas.width,myCanvas.height,{mipMap:false})
            }

            const wi = this.GetWorldInfo();
            const quad = wi.GetBoundingQuad();
            const rcTex = new C3.Rect(0,0,1,1) // Possible to get from this._texture instead? Not needed, not spritesheeted?

            renderer.UpdateTexture(myCanvas, this._elementTexture, {})

            renderer.SetTexture(this._elementTexture)
            
            if (this._runtime.IsPixelRoundingEnabled())
            {
                const ox = Math.round(wi.GetX()) - wi.GetX();
                const oy = Math.round(wi.GetY()) - wi.GetY();
                tempQuad.copy(quad);
                tempQuad.offset(ox, oy);
                renderer.Quad3(tempQuad, rcTex);
            }
            else
            {
                renderer.Quad3(quad, rcTex);
            }
        }

        SaveToJson()
        {
            return {
                // data to be saved for savegames
            };
        }

        LoadFromJson(o)
        {
            // load state for savegames
        }

        GetDebuggerProperties()
        {
            return [
            {
                title: "ElementQuad",
                properties: [
                    //{name: ".current-animation",	value: this._currentAnimation.GetName(),	onedit: v => this.CallAction(Acts.SetAnim, v, 0) },
                ]
            }];
        }
    };
}