﻿// ECMAScript 5 strict mode
"use strict";

assert2(cr, "cr namespace not created");
assert2(cr.plugins_, "cr.plugins_ not created");

/////////////////////////////////////
// Plugin class
cr.plugins_.ppstudio_handy_utilities = function(runtime)
{
	this.runtime = runtime;
};

function createCSSData(data){
	if (data){
		var styleTag = document.createElement("style");
		styleTag.innerHTML =  data;
		document.getElementsByTagName("head")[0].appendChild(styleTag);
	}
}

(function ()
{
	var pluginProto = cr.plugins_.ppstudio_handy_utilities.prototype;
	
		
	/////////////////////////////////////
	// Object type class
	pluginProto.Type = function(plugin)
	{
		this.plugin = plugin;
		this.runtime = plugin.runtime;
	};

	var typeProto = pluginProto.Type.prototype;

	typeProto.onCreate = function()
	{
		
	};
	
	/////////////////////////////////////
	// Instance class
	pluginProto.Instance = function(type)
	{
		this.type = type;
		this.runtime = type.runtime;
		
		// Initialise object properties
		//this.testProperty = 0;
	};
	
	var instanceProto = pluginProto.Instance.prototype;
	
	instanceProto.ActivateAnalytics = function(){
		if (self["ga"]!=="undefined"){
			self["ga"]('create', this._gaID, 'auto');
			self["ga"]('send', 'pageview');
			this._GAEnabled=true;
		}
	}

	instanceProto.onCreate = function()
	{		
		this._gaID = this.properties[0];
		this._trackPreview = this.properties[1];
		this._initType = this.properties[2];
		this._GAEnabled=false;

		if ((!this.runtime.isPreview || this._trackPreview)&&this._initType==0)
			this.ActivateAnalytics();
	};
			
	instanceProto.saveToJSON = function ()
	{
		return {};
	};
	
	instanceProto.loadFromJSON = function (o)
	{
	};
	
	/**BEGIN-PREVIEWONLY**/
	instanceProto.getDebuggerValues = function (propsections)
	{
	};
	/**END-PREVIEWONLY**/

	//////////////////////////////////////
	// Conditions
	function Cnds() {};
	
	Cnds.prototype.IsTracking = function ()
	{
		return this._GAEnabled;
	};
	
	pluginProto.cnds = new Cnds();

	//////////////////////////////////////
	// Actions
	function Acts() {};

	Acts.prototype.InitGA = function()
	{
		debugger;
		this.ActivateAnalytics();
	};

	Acts.prototype.ImportCSSData = function(data)
	{
		createCSSData(data);
		//console.log(data);
	};
	
	Acts.prototype.ImportScriptData = function(data){
		var head = document.getElementsByTagName("head")[0];
		var scriptTag = document.createElement("script");
		scriptTag.innerHTML = data;
		head.appendChild(scriptTag);
	};
	
	Acts.prototype.ImportScriptSrc = function(data){
		var head = document.getElementsByTagName("head")[0];
		var scriptTag = document.createElement("script");
		scriptTag.setAttribute("src",data);
		head.appendChild(scriptTag);
	};
	
	Acts.prototype.GASendEvent = function(cat,act,lbl,val){
		if (self["ga"]!=="undefined")
			self["ga"]('send','event',cat,act,lbl,val);
	}
	
	pluginProto.acts = new Acts();

	//////////////////////////////////////
	// Expressions
	function Exps() {};
	
	Exps.prototype.GetCurrentTime = function(ret)
	{
		// Reads browse's current time in milliseconds
		ret.set_int(new Date().getTime());
	};
	
	Exps.prototype.GetLocalTime = function(ret)
	{
		// Reads browse's current time in milliseconds
		var dtime = new Date();
		var time = dtime.getTimezoneOffset()+dtime.getTime();
		ret.set_int(time);
	};
	
	Exps.prototype.NowUTCTimestamp = function(ret)
	{
		// Reads browse's current time in milliseconds
		var dTime = new Date();
		var time = dTime.toUTCString();
		ret.set_string(time);
	};
	
	Exps.prototype.FormatUTCDate = function(ret,milli)
	{
		var date = new Date(milli);
		ret.set_string(date.toUTCString());
	};		
	
	Exps.prototype.FormatTime = function (ret, number)
	{
		/*var time = Math.floor(number/1000);
		var hours = Math.floor(time / 3600);
		var seconds = Math.floor(time % 60);
		var minutes = Math.floor((time % 3600)/60);
		
		var timeFormat = "";
		var hoursStr = "";
		var secondsStr = "";
		var minutesStr = "";
		
		hoursStr = (hours<10)?"0"+hours.toString():hours.toString();
		minutesStr = (minutes>=60)?"00": (minutes<10)?"0"+minutes.toString():minutes.toString();
		secondsStr= (seconds>=60)?"00": (seconds<10)?"0"+seconds.toString():seconds.toString();
		
		timeFormat = hoursStr+":"+minutesStr+":"+secondsStr;*/

		var d=new Date(number);
		
		//var time = Math.floor(number/1000);
		//var hours = d.getHours();
		var hours = Math.floor(number/3600000);
		var seconds = d.getSeconds();
		var minutes = d.getMinutes();
		
		var timeFormat = "";
		var hoursStr = "";
		var secondsStr = "";
		var minutesStr = "";
		
		hoursStr = (hours<10)?"0"+hours.toString():hours.toString();
		minutesStr = (minutes>=60)?"00": (minutes<10)?"0"+minutes.toString():minutes.toString();
		secondsStr= (seconds>=60)?"00": (seconds<10)?"0"+seconds.toString():seconds.toString();
		
		timeFormat = hoursStr+":"+minutesStr+":"+secondsStr;		
		
		ret.set_string(timeFormat);
	};
	
	Exps.prototype.CreateDate = function(ret, year, month, day, hours, minutes, seconds, milliseconds){
		ret.set_int(new Date(year,month,day,hours,minutes,seconds,milliseconds).getTime());
	}
	
	Exps.prototype.FormatISODate = function(ret,milli){
		ret.set_string(new Date(milli).toISOString());
	}
	
	pluginProto.exps = new Exps();

}());