# Google Analytics & Handy Utilities
Construct 3 plugin Usefull set of utilities including Google Analytics (`analytics.js`)

Handy Utilities plugin contains a small set of usefull expressions and actions for formating dates as well as creating them directly in your project without the need to know how to program in Javascript, we are trying to make it easy for you.

This Plugin has support for **Construct 2 and Construct 3 Runtimes, worker mode and advanced minification on C3 runtime.**

# HTML Tag Utilities

## Actions
## ImportCSSData (Deprecated)
Import CSS data into the project by injecting a code snipet as string. This will create a <style> element in your project affecting all the components. Usefull for formating inputs, text labels and buttons. You may create the CSS file directly in your construct 3 project, then access the file using the AJAX plugin and using `AJAX.lastData` as the string to be passed to this action.

|Parameters|Description|
|-|-|
|**Data**|String containing the CSS code to be injected with <style> tag|

## Import Script Data (Deprecated)
Import Javascript code snipet into the project by injecting it as string. This will create a <script> element in your project. You may create the Javascript files directly in your construct 3 project, then access the file using the AJAX plugin and using `AJAX.lastData` as the string to be passed to this action.

|Parameters|Description|
|-|-|
|**data**|String containing the Javascript code to be injected with <script> tag|

## Import Script Src (Deprecated)
Import Javascript URL into the project by injecting it as string. This will create a <script> element in your project then will set the src attribute to use the one you passed. You may create the Javascript files directly in your construct 3 project, then access the file using the AJAX plugin and using AJAX.lastData as the string to be passed to this action.

|Parameters|Description|
|-|-|
|**data**|String containing the Javascript source URL to be used in the <script src=data> tag|

# Google Analytics

Google Analytics is called using **“ga”** object. To make it work properly you have to provide the Google Analytics Property ID to make it work.

|Properties|Description|
|-|-|
|**Google Analytics ID**|Google Analytics Property ID usually a string un the form of `UA-XXXXX-Y`|
|**Track Preview Mode**|Enables tracking in preview mode. This check is meant for testing only, although it won’t affect your final HTML export. Is usefull to verify directly in the construct 3 preview if your site is being tracked, and if the events are being sent.|

## Actions
## Send Event
Sends an event to Google Analytics console using the ga object as follows.

```javascript
ga('send', 'event', [eventCategory], [eventAction], [eventLabel], [eventValue])[fieldsObject]);
```

In your project you just have to call the Send Event action.

|Parameters|Description|
|-|-|
|**eventCategory**|mandatory	Typically the object that was interacted with (e.g. ‘Video’)|
|**eventAction**|mandatory	The type of interaction (e.g. ‘play’)|
|**eventLabel**	|Useful for categorizing events (e.g. ‘Fall Campaign’)|
|**eventValue**	|A numeric value associated with the event (e.g. 42)|

# Javascript Utilities

## Expressions

## GetCurrentTime
Returns browser’s current time in milliseconds

## GetLocalTime
Returns browser’s current time plus timezone offset in milliseconds

## NowUTCTimestamp
Returns current timestamp un UTC format. (e.g. Mon, 15 Jul 2019 05:31:11 GMT )

## FormatTime
Converts a number (milliseconds) to a string in the form of HH:MM:SS.

|Parameters|Description|
|-|-|
|**milliseconds** |Milliseconds to convert into HH:MM:SS format|

## FormatUTCDate
Converts milliseconds into a string representing a date object in UTC format (e.g. Mon, 15 Jul 2019 05:31:11 GMT )

|Parameters|Description|
|-|-|
|**milliseconds**|Milliseconds to convert into HH:MM:SS format|

## CreateDate
Creates a Date object based on the parameters and returns its representation in milliseconds.

|Parameters|Description|
|-|-|
|**Year**|Year|
|**Month**|Month|
|**Day**|Day|
|**Hours**|Hours|
|**Minutes**|Minutes|
|**Seconds**|Seconds|
|**Milliseconds**|Milliseconds|

## FormatISODate

Return a Date object as a String, using the ISO standard (e.g. 2019-07-15T05:44:26.745Z )

|Parameters|Description|
|-|-|
|**Milliseconds**|Milliseconds representing the date to be converted to ISO format|
