"use strict";

{
	const DOM_COMPONENT_ID = "ppstudio_handy_DOM";
	
	C3.Plugins.ppstudio_handy_utilities.Instance = class ppstudio_handy_utilities_Instance extends C3.SDKInstanceBase
	{		
		constructor(inst, properties)
		{
			super(inst, DOM_COMPONENT_ID); //Registering the DOM component for the 
			
			if (properties){
				this._gaID = properties[0];
				this._trackPreview = properties[1];
				this._GAEnabled=null;
			}
						
			if (this._trackPreview || !this._runtime.IsPreview()){
			// Get initial state from DOM. Make runtime loading wait for the response.
				const data = {
					"gaID":this._gaID
				}
				// First we need to add a LoadPromise to make sure that GA is loaded before continuing
				this._runtime.AddLoadPromise(
					this.PostToDOMAsync("load", data)
						.then((data) => {
								this._GAEnabled = data["GAEnabled"];
							})
				)
			}
		}
		
		createCSSData(data){
			if (data){
				this.PostToDOM("inject-css", data)
			}
		}
		
		Release()
		{
			super.Release();
		}
		
		Draw(renderer)
		{
		}
		
		SaveToJson()
		{
			return {
				// data to be saved for savegames
			};
		}
		
		LoadFromJson(o)
		{
			// load state for savegames
		}		
	};
	
}