"use strict";
{

    const PLUGIN_ID = "Mikal_FaceAPI";
    const PLUGIN_VERSION = "1.0.0.0";
    const PLUGIN_CATEGORY = "media";

    const PLUGIN_CLASS = SDK.Plugins.Mikal_FaceAPI = class FaceAPIPlugin extends SDK.IPluginBase
    {
        constructor()
        {
            super(PLUGIN_ID);

            SDK.Lang.PushContext("plugins." + PLUGIN_ID.toLowerCase());

            this._info.SetName(lang(".name"));
            this._info.SetDescription(lang(".description"));
            this._info.SetVersion(PLUGIN_VERSION);
            this._info.SetCategory(PLUGIN_CATEGORY);
            this._info.SetAuthor("Mikal");
            this._info.SetHelpUrl(lang(".help-url"));
            this._info.SetIsSingleGlobal(true);

            this._info.SetSupportedRuntimes(["c3"]);

            SDK.Lang.PushContext(".properties");

            this._info.SetProperties([

            ]);


            this._info.AddFileDependency(
            {
                filename: "face-api.js",
                type: "external-script"
            });
            this._info.AddFileDependency(
            {
                filename: "face_landmark_68_model-shard1.bin",
                type: "copy-to-output",
                fileType: "application/octet-stream"
            });
            this._info.AddFileDependency(
            {
                filename: "face_landmark_68_model-weights_manifest.json",
                type: "copy-to-output",
                fileType: "application/octet-stream"
            });
            this._info.AddFileDependency(
            {
                filename: "face_recognition_model-shard1.bin",
                type: "copy-to-output",
                fileType: "application/octet-stream"
            });
            this._info.AddFileDependency(
            {
                filename: "face_recognition_model-shard2.bin",
                type: "copy-to-output",
                fileType: "application/octet-stream"
            });
            this._info.AddFileDependency(
            {
                filename: "face_recognition_model-weights_manifest.json",
                type: "copy-to-output",
                fileType: "application/octet-stream"
            });
            this._info.AddFileDependency(
            {
                filename: "ssd_mobilenetv1_model-shard1.bin",
                type: "copy-to-output",
                fileType: "application/octet-stream"
            });
            this._info.AddFileDependency(
            {
                filename: "ssd_mobilenetv1_model-shard2.bin",
                type: "copy-to-output",
                fileType: "application/octet-stream"
            });
            this._info.AddFileDependency(
            {
                filename: "ssd_mobilenetv1_model-weights_manifest.json",
                type: "copy-to-output",
                fileType: "application/octet-stream"
            });

            SDK.Lang.PopContext(); //.properties
            SDK.Lang.PopContext();
        }
    };

    PLUGIN_CLASS.Register(PLUGIN_ID, PLUGIN_CLASS);
}