"use strict";
{
    C3.Plugins.Mikal_FaceAPI.Acts = {
        async InitializeModels()
        {
            //implementation
            var modelPath = './'
            console.log("Init models with path: " + modelPath)
            try
            {
                await faceapi.loadSsdMobilenetv1Model(modelPath)
                console.log("loadSsdMobilenetv1Model complete")
                await faceapi.loadFaceLandmarkModel(modelPath)
                console.log("loadFaceLandmarkModel complete")
                await faceapi.loadFaceRecognitionModel(modelPath)
                console.log("loadFaceLandmarkModel complete")

            }
            catch (err)
            {
                alert(err)
            }
        },

        async FaceDetectSingle(uri)
        {
            // input = document.querySelector('canvas')
            let img = await faceapi.fetchImage(uri);
            const detection = await faceapi.detectSingleFace(img)
            this.detection = detection
        },

        async FaceDetectSingleLandmarks(uri)
        {
            // input = document.querySelector('canvas')
            let img = await faceapi.fetchImage(uri);
            const detectionWithLandMarks = await faceapi.detectSingleFace(img).withFaceLandmarks()
            this.detectionWithLandMarks = detectionWithLandMarks
            this.detection = detectionWithLandMarks
        }
    };
}