

/////////////////////////////////////////////////////////
// FlameBall

const int MAX_ITERATIONS = 256;

//The current foreground texture co-ordinate
varying mediump vec2 vTex;
//The foreground texture sampler, to be sampled at vTex
uniform lowp sampler2D samplerFront;
//The current foreground rectangle being rendered
uniform mediump vec2 srcStart;
uniform mediump vec2 srcEnd;
//The current foreground source rectangle being rendered
uniform mediump vec2 srcOriginStart;
uniform mediump vec2 srcOriginEnd;
//The current foreground source rectangle being rendered, in layout 
uniform mediump vec2 layoutStart;
uniform mediump vec2 layoutEnd;
//The background texture sampler used for background - blending effects
uniform lowp sampler2D samplerBack;
//The current background rectangle being rendered to, in texture co-ordinates, for background-blending effects
uniform mediump vec2 destStart;
uniform mediump vec2 destEnd;
//The time in seconds since the runtime started. This can be used for animated effects
uniform mediump float seconds;
//The size of a texel in the foreground texture in texture co-ordinates
uniform mediump vec2 pixelSize;
//The current layer scale as a factor (i.e. 1 is unscaled)
uniform mediump float layerScale;
//The current layer angle in radians.
uniform mediump float layerAngle;

uniform lowp float resolutionX;
uniform lowp float resolutionY;
uniform lowp float iterations;
uniform lowp vec3 colorA;
uniform lowp vec3 colorB;
uniform lowp float glowScale;
uniform lowp float glowPower;
uniform lowp float timeScale;

#ifdef GL_ES
precision mediump float;
#endif

// <port> uniform float time;
float time = seconds * timeScale;

int iterationsInt = int(iterations);

// <port>
// uniform vec2 resolution 
vec2 resolution = vec2(resolutionX, resolutionY);


float noise(vec3 p) //Thx to Las^Mercury
{
  vec3 i = floor(p);
	vec4 a = dot(i, vec3(1., 57., 21.)) + vec4(0., 57., 21., 78.);
	vec3 f = cos((p-i)*acos(-1.))*(-.5)+.5;
	a = mix(sin(cos(a)*a),sin(cos(1.+a)*(1.+a)), f.x);
	a.xy = mix(a.xz, a.yw, f.y);
	return mix(a.x, a.y, f.z);
}

//-----------------------------------------------------------------------------
// Scene/Objects
//-----------------------------------------------------------------------------
float sphere(vec3 p, vec4 spr)
{
	return length(spr.xyz-p) - spr.w;
}

float fire(vec3 p)
{
	float d= sphere(p*vec3(1.,.5,1.), vec4(.0,-1.,.0,1.));
	return d+(noise(p+vec3(.0,time*2.,.0))+noise(p*3.)*.5)*.25*(p.y) ;
}
//-----------------------------------------------------------------------------
// Raymarching tools
//-----------------------------------------------------------------------------
float scene(vec3 p)
{
	return min(100.-length(p) , abs(fire(p)) );
}



vec4 Raymarche(vec3 org, vec3 dir)
{
	float d=0.0;
	vec3  p=org;
	float glow = 0.0;
	float eps = 0.02;
	bool glowed=false;
	for(int i=0; i<MAX_ITERATIONS; i++)
	{
		if (i >= iterationsInt){break;}
		d = scene(p) + eps;
		p += d * dir;
		if( d>eps )
		{
			if( fire(p) < .0)
				glowed=true;
			if(glowed)
       			glow = float(i)/iterations;
		}
	}
	return vec4(p,glow);
}

//-----------------------------------------------------------------------------
// Main functions
//-----------------------------------------------------------------------------

void main()
{
	// <port>
	vec2 uvNormalized = (vTex-srcOriginStart)/(srcOriginEnd-srcOriginStart);
	
//	vec2 v = -1.0 + 2.0 * gl_FragCoord.xy / resolution.xy;
	vec2 v = -1.0 + 2.0 * uvNormalized / resolution.xy;
	v.x *= resolution.x/resolution.y;
	vec3 org = vec3(0.,-2.,4.);
	vec3 dir   = normalize(vec3(v.x*1.6,-v.y,-1.5));
	vec4 p = Raymarche(org,dir);
	float glow = p.w;
	gl_FragColor = mix(vec4(0.), mix(vec4(colorA,1.),vec4(colorB,1.),p.y*.02+.4), pow(glow*glowScale,glowPower));
//	gl_FragColor = vec4(0.1,.5,1.,1.);
	//gl_FragColor = mix(vec4(1.), mix(vec4(1.,.5,.1,1.),vec4(0.1,.5,1.,1.),p.y*.02+.4), pow(glow*2.,4.));

}
