/////////////////////////////////////////////////////////
// Ripple
precision mediump float;
precision mediump int;

//The current foreground texture co-ordinate
varying mediump vec2 vTex;
//The foreground texture sampler, to be sampled at vTex
uniform lowp sampler2D samplerFront;

uniform mediump float seconds;

uniform lowp float timeScale;
uniform lowp float screenX;
uniform lowp float screenY;
uniform lowp float magnitude;

void main() {
   vec2 vUv = vTex;
   float x = vUv.x * screenX;
   float y = vUv.y * screenY;
   float time = seconds;

   float scaleTime = time * timeScale;

   float mov0 = x+y+sin(scaleTime)*10.+sin(x/90.)*70.+scaleTime*2.;
   float mov1 = (mov0 / 5. + sin(mov0 / 30.))/ 10. + scaleTime * 3.;
   float mov2 = mov1 + sin(mov1)*5. + scaleTime*1.0;
   float cl1 = sin(sin(mov1/4. + scaleTime)+mov1);
   float c1 = cl1 +mov2/2.-mov1-mov2+scaleTime;
   float c2 = sin(c1+sin(mov0/100.+scaleTime)+sin(y/57.+scaleTime/50.)+sin((x+y)/200.)*2.);

    // ( red, green, blue, alpha ).
    gl_FragColor = texture2D(samplerFront, vUv +vec2(c2,c2)/(101. - magnitude));

}