/////////////////////////////////////////////////////////
// SpaceTime with five voids

// Set the precision for data types used in this shader
precision mediump float;
precision mediump int;

//The current foreground texture co-ordinate
varying mediump vec2 vTex;
//The foreground texture sampler, to be sampled at vTex
uniform lowp sampler2D samplerFront;
//The current foreground source rectangle being rendered
uniform mediump vec2 srcOriginStart;
uniform mediump vec2 srcOriginEnd;

uniform lowp float void0X;
uniform lowp float void0Y;
uniform lowp float void1X;
uniform lowp float void1Y;
uniform lowp float void2X;
uniform lowp float void2Y;
uniform lowp float void3X;
uniform lowp float void3Y;
uniform lowp float void4X;
uniform lowp float void4Y;
uniform lowp float void0Size;
uniform lowp float void1Size;
uniform lowp float void2Size;
uniform lowp float void3Size;
uniform lowp float void4Size;
uniform lowp float invert0;
uniform lowp float invert1;
uniform lowp float invert2;
uniform lowp float invert3;
uniform lowp float invert4;

void main(void)
{
	// normalize from spritesheet
    vec2 vUv = (vTex-srcOriginStart)/(srcOriginEnd-srcOriginStart);
    vec4 tcolor0;
    vec2 myAngle0, myAngle1, myAngle2, myAngle3,myAngle4;
    float dist0,dist1,dist2,dist3,dist4;
    vec2 void0XY = vec2(void0X, void0Y);
    vec2 void1XY = vec2(void1X, void1Y);
    vec2 void2XY = vec2(void2X, void2Y);
    vec2 void3XY = vec2(void3X, void3Y);
    vec2 void4XY = vec2(void4X, void4Y);
    
    dist0 =  distance(vUv,void0XY);
    dist1 =  distance(vUv,void1XY);
    dist2 =  distance(vUv,void2XY);
    dist3 =  distance(vUv,void3XY);
    dist4 =  distance(vUv,void4XY);
    
    myAngle0 = invert0*normalize(void0XY - vUv)*(1.0-distance(vUv,void0XY))/void0Size;
    myAngle1 = invert1*normalize(void1XY - vUv)*(1.0-distance(vUv,void1XY))/void1Size;
    myAngle2 = invert2*normalize(void2XY - vUv)*(1.0-distance(vUv,void2XY))/void2Size;
    myAngle3 = invert3*normalize(void3XY - vUv)*(1.0-distance(vUv,void3XY))/void3Size;
    myAngle4 = invert4*normalize(void4XY - vUv)*(1.0-distance(vUv,void4XY))/void4Size;
    
    vUv = vUv-myAngle0-myAngle1-myAngle2-myAngle3-myAngle4;
    // denormalize for spritesheet
    vUv = vUv * (srcOriginEnd - srcOriginStart) + srcOriginStart;
    
    tcolor0=texture2D(samplerFront, vUv);
    // tcolor0.a=pow(dist0, distPow)*distScale;

    gl_FragColor = tcolor0*1.;
    
}