/////////////////////////////////////////////////////////
// StarfieldCycle
precision mediump float;
precision mediump int;

//The current foreground texture co-ordinate
varying mediump vec2 vTex;
//The foreground texture sampler, to be sampled at vTex
uniform lowp sampler2D samplerFront;
//The current foreground rectangle being rendered
uniform mediump vec2 srcStart;
uniform mediump vec2 srcEnd;
//The current foreground source rectangle being rendered
uniform mediump vec2 srcOriginStart;
uniform mediump vec2 srcOriginEnd;
//The current foreground source rectangle being rendered, in layout 
uniform mediump vec2 layoutStart;
uniform mediump vec2 layoutEnd;
//The background texture sampler used for background - blending effects
uniform lowp sampler2D samplerBack;
//The current background rectangle being rendered to, in texture co-ordinates, for background-blending effects
uniform mediump vec2 destStart;
uniform mediump vec2 destEnd;
//The time in seconds since the runtime started. This can be used for animated effects
uniform mediump float seconds;
//The size of a texel in the foreground texture in texture co-ordinates
uniform mediump vec2 pixelSize;
//The current layer scale as a factor (i.e. 1 is unscaled)
uniform mediump float layerScale;
//The current layer angle in radians.
uniform mediump float layerAngle;

// http://casual-effects.blogspot.com/2013/08/starfield-shader.html

#define iterations 17
#define volsteps 3
#define stepsize 0.2
#define frequencyVariation   1.3

uniform vec3 colorBase;
uniform float twinkleSpeed;
uniform float speed;
 
uniform float brightness;
uniform float distfading;
uniform float sparsity;
uniform float starfieldOpacity;

#define PI 3.141592653589793238462643383279

void main( void ) {
	// Use C3 uniform and normalize for spritesheet
    vec2 vUv = vTex;
    vUv = (vUv-srcOriginStart)/(srcOriginEnd - srcOriginStart);
    
    float time = seconds;
    
    vec2 uv = vUv.xy + 0.5;
    uv.x += time * speed * 0.1;
 
    vec3 dir = vec3(uv * 2.0, 1.0);
 
    float s = 0.1, fade = 0.01;
    vec3 starColor = vec3(0.0);
     
    for (int r = 0; r < volsteps; ++r) {
        vec3 p =  (time * speed * twinkleSpeed) + dir * (s * 0.5);
        p = abs(vec3(frequencyVariation) - mod(p, vec3(frequencyVariation * 2.0)));
 
        float prevlen = 0.0, a = 0.0;
        for (int i = 0; i < iterations; ++i) {
            p = abs(p);
            p = p * (1.0 / dot(p, p)) + (-sparsity); // the magic formula            
            float len = length(p);
            a += abs(len - prevlen); // absolute sum of average change
            prevlen = len;
        }
         
        a *= a * a; // add contrast
         
        // coloring based on distance        
        starColor += (vec3(s, s*s, s*s*s) * a * brightness + 1.0) * fade;
        fade *= distfading; // distance fading
        s += stepsize;
    }
     
    starColor = min(starColor, vec3(1.2));
 
    // Detect and suppress flickering single pixels (ignoring the huge gradients that we encounter inside bright areas)
    float intensity = min(starColor.r + starColor.g + starColor.b, 0.7);
 
    vec2 sgn = (vec2(vUv.xy)) * 2.0 - 1.0;
 //   vec2 gradient = vec2(dFdx(intensity) * sgn.x, dFdy(intensity) * sgn.y);
    vec2 gradient = vec2(0.1, 0.1);
    float cutoff = max(max(gradient.x, gradient.y) - 0.1, 0.0);
    starColor *= max(1.0 - cutoff * 6.0, 0.3);
 
    // Motion blur; increases temporal coherence of undersampled flickering stars
    // and provides temporal filtering under true motion.  
    gl_FragColor = vec4( starColor * colorBase, starfieldOpacity );
}