"use strict";

const precision = 100;

const backV = 1.70158;
const ease = {
	["linear"]: function (t) { return t },
	["easeInQuad"]: function (t) { return t*t },
	["easeOutQuad"]: function (t) { return t*(2-t) },
	["easeInOutQuad"]: function (t) { return t<.5 ? 2*t*t : -1+(4-2*t)*t },
	["easeInCubic"]: function (t) { return t*t*t },
	["easeOutCubic"]: function (t) { return (--t)*t*t+1 },
	["easeInOutCubic"]: function (t) { return t<.5 ? 4*t*t*t : (t-1)*(2*t-2)*(2*t-2)+1 },
	["easeInQuart"]: function (t) { return t*t*t*t },
	["easeOutQuart"]: function (t) { return 1-(--t)*t*t*t },
	["easeInOutQuart"]: function (t) { return t<.5 ? 8*t*t*t*t : 1-8*(--t)*t*t*t },
	["easeInQuint"]: function (t) { return t*t*t*t*t },
	["easeOutQuint"]: function (t) { return 1+(--t)*t*t*t*t },
	["easeInOutQuint"]: function (t) { return t<.5 ? 16*t*t*t*t*t : 1+16*(--t)*t*t*t*t },
	["easeInElastic"]: function (t) { return .04 * t / (--t) * Math.sin(25 * t) },
	["easeOutElastic"]: function (t) { return (.04 - .04 / t) * Math.sin(25 * t) + 1 },
	["easeInOutElastic"]: function (t) { return (t -= .5) < 0 ? (.02 + .01 / t) * Math.sin(50 * t) : (.02 - .01 / t) * Math.sin(50 * t) + 1 },
	["easeInBack"]: function (t) {return t * t * ((backV + 1) * t - backV)},
	["easeOutBack"]: function (t) {return --t * t * ((backV + 1) * t + backV) + 1},
	["easeInOutBack"]: function (t) {if ((t *= 2) < 1){ return 0.5 * (t * t * ((backV + 1) * t - backV))} return 0.5 * ((t -= 2) * t * ((backV + 1) * t + backV) + 2)},
	["easeInBounce"]: function (t) {return 1-ease.easeOutBounce(1-t)},
	["easeOutBounce"]: function (t) {

        if ( t < ( 1 / 2.75 ) ) {

            return 7.5625 * t * t;

        } else if ( t < ( 2 / 2.75 ) ) {

            return 7.5625 * ( t -= ( 1.5 / 2.75 ) ) * t + 0.75;

        } else if ( t < ( 2.5 / 2.75 ) ) {

            return 7.5625 * ( t -= ( 2.25 / 2.75 ) ) * t + 0.9375;

        } else {

            return 7.5625 * ( t -= ( 2.625 / 2.75 ) ) * t + 0.984375;

        }

    },
	easeInOutBounce: function (t){
		if (t < 0.5) return ease.easeInBounce(t*2)*0.5;
		return ease.easeOutBounce(t*2-1) * 0.5 + 0.5;
	}
  
  
}

{
	C3.Behaviors.wackytoasterTweeen.Instance = class MyBehaviorInstance extends C3.SDKBehaviorInstanceBase
	{
		constructor(behInst, properties)
		{
			super(behInst);
			
			if (properties)
			{

			}
			
			//Initialize variables
			this.wTween = {};
			this.wTimeline = {};
			this.wState = {};
			
			this.activeTween = {};
			this.activeTimeline = [];
			this.activeTimelineName = "";
			this.inTimeline = false;
			this.timelinePos = 0;
			this.toTween = {};
			this.direction = 0;
			this.initDirection = 0;
			this.progress = 0;
			this.delay = 0;
			this.repeatCount = 0;
			this.timelineDelay = 0;
			
			this.unTick = false;
			this.postTick = 0;
			this.tickCooldown = 3;
			
			this.tweenComplete = "";
			this.anyComplete = "";
			this.reverseComplete = "";
			this.anyReverseComplete = "";
			this.tweenReverseFinished = "";
			this.anyReverseFinished = "";
			this.tweenFinished = "";
			this.anyFinished = "";
			this.timelineFinished = "";
			this.timelineReverseFinished = "";
			
			this.initialValues = {};
			this.resultValues = {};
			
			
			// Opt-in to getting calls to Tick()
			// this._StartTicking();
		}

		Release()
		{
			super.Release();
		}
		
		SaveToJson()
		{
			return {
				// data to store for savegames
			};
		}

		LoadFromJson(o)
		{
			// load state for savegames
		}
		
		
		Tick()
		{
			
			const dt = this._runtime.GetDt(this._inst);
			const wi = this._inst.GetWorldInfo();
			
			//console.warn("test", this.toTween, this.activeTween);
			//return;
			
			if (this.unTick){
				this.postTick++;
				
				if (this.postTick >= this.tickCooldown){
					this.postTick = 0;
					this.unTick = false;
					this._StopTicking();
				}
				return;
			}
			
			//delay
			if (this.delay < this.activeTween["repeatDelay"] || this.delay < this.timelineDelay){
				this.delay += dt;
				return;
			}
			
			//progress tween
			if (this.direction === 0){
				this.progress = this.progress + (1/this.activeTween["duration"]) * dt;
			} else {
				this.progress = this.progress - (1/this.activeTween["duration"]) * dt;
			}
			
			//calculate only the values defined in the tween
			//also sets the world instance to the new values	
			if (this.toTween["x"]){
				this.resultValues.x = ease[this.activeTween["ease"]](this.progress) * (this.activeTween["x"] - this.initialValues["x"]) + this.initialValues["x"];
				wi.SetX(this.resultValues.x);
			}
			
			if (this.toTween["y"]){
				this.resultValues.y = ease[this.activeTween["ease"]](this.progress) * (this.activeTween["y"] - this.initialValues["y"]) + this.initialValues["y"];
				wi.SetY(this.resultValues.y);
			}
	
			if (this.toTween["w"]){
				this.resultValues.w = ease[this.activeTween["ease"]](this.progress) * (this.activeTween["w"] - this.initialValues["w"]) + this.initialValues["w"];
				wi.SetWidth(this.resultValues.w);
			}

			if (this.toTween["h"]){
				this.resultValues.h = ease[this.activeTween["ease"]](this.progress) * (this.activeTween["h"] - this.initialValues["h"]) + this.initialValues["h"];
				wi.SetHeight(this.resultValues.h);
			}

			if (this.toTween["a"]){
				this.resultValues.a = ease[this.activeTween["ease"]](this.progress) * (C3.toRadians(this.activeTween["a"]) - this.initialValues["a"]) + this.initialValues["a"];
				wi.SetAngle(this.resultValues.a);
			}
			
			if (this.toTween["o"]){
				this.resultValues.o = ease[this.activeTween["ease"]](this.progress) * (this.activeTween["o"] - this.initialValues["o"]) + this.initialValues["o"];
				wi.SetOpacity(this.resultValues.o);
			}
			
			//on tween reached end
			if (this.progress > 1 - 1/precision/this.activeTween["duration"] && this.direction === 0 || this.progress < 0 + 1/precision/this.activeTween["duration"] && this.direction === 1){
				
				//set finishing position to exact target values
				if (this.direction === 0){
					this.progress = 1;
				
					if (this.toTween["x"]){wi.SetX(this.activeTween["x"])};
					if (this.toTween["y"]){wi.SetY(this.activeTween["y"])};
					if (this.toTween["w"]){wi.SetWidth(this.activeTween["w"])};
					if (this.toTween["h"]){wi.SetHeight(this.activeTween["h"])};
					if (this.toTween["a"]){wi.SetAngle(C3.toRadians(this.activeTween["a"]))};
					if (this.toTween["o"]){wi.SetOpacity(this.activeTween["o"])};
				} else {
					this.progress = 0;
				
					if (this.toTween["x"]){wi.SetX(this.initialValues["x"])};
					if (this.toTween["y"]){wi.SetY(this.initialValues["y"])};
					if (this.toTween["w"]){wi.SetWidth(this.initialValues["w"])};
					if (this.toTween["h"]){wi.SetHeight(this.initialValues["h"])};
					if (this.toTween["a"]){wi.SetAngle(this.initialValues["a"])};
					if (this.toTween["o"]){wi.SetOpacity(this.initialValues["o"])};
				}
				
				//set these up for triggers later
				this.tweenComplete = this.activeTween["tweenID"];
				this.reverseComplete = this.activeTween["tweenID"];
				this.tweenFinished = this.activeTween["tweenID"];
				this.reverseFinished = this.activeTween["tweenID"];
				
				//complete triggers
				if (this.direction === 0){
					this.Trigger(C3.Behaviors.wackytoasterTweeen.Cnds.tweenComplete);
					
					this.anyComplete = this.GetSdkType().GetBehaviorType().GetName();
					this.Trigger(C3.Behaviors.wackytoasterTweeen.Cnds.anyComplete);
					
				} else {
					this.Trigger(C3.Behaviors.wackytoasterTweeen.Cnds.reverseComplete);
					
					this.anyReverseComplete = this.GetSdkType().GetBehaviorType().GetName();
					this.Trigger(C3.Behaviors.wackytoasterTweeen.Cnds.anyReverseComplete);
					
				}
				
				//repeat
				this.repeatCount++;
				this.timelineDelay = 0;
				if (this.activeTween["repeat"] > this.repeatCount){
					if (!this.activeTween["yoyo"]){this.progress = 0};
				} else {
					this.repeatCount = 0;
					this.activeTween = "";
					
					if (this.inTimeline){
						
						if (this.initDirection === 0){
							this.timelinePos++;
							
							//console.warn(this.activeTimeline["length"] - 1, " < ", this.timelinePos);
							
							if(this.activeTimeline["length"] - 1 < this.timelinePos){
							
								this.activeTimeline = "";
								this.activeTimelineName = "";
								this.inTimeline = false;
								
								this.progress = 0;
								this.timelinePos = 0;
								this.timelineDelay = 0;
								
								this.unTick = true;
								//this._StopTicking();
								
								//timeline finished triggers
								this.Trigger(C3.Behaviors.wackytoasterTweeen.Cnds.timelineFinished);
								this.delay = 0;
								wi.SetBboxChanged();
								return;
							
							} else {
								
								this.timelineDelay = 0;
								
								while (typeof this.activeTimeline[this.timelinePos] === "number"){
									this.timelineDelay = this.timelineDelay + this.activeTimeline[this.timelinePos];
									this.timelinePos++;
								}
								
								setupTween(this, this.wTween[this.activeTimeline[this.timelinePos]], this.initDirection);
								setupToTween(this);
								
								//fix for yoyo weirdness during timelines. Needs an extra repeat to properly reflect the amounts of repeats for reasons
								if(this.wTween[this.activeTimeline[this.timelinePos]]["yoyo"]){
									this.repeatCount = -1;
								}
								
								this.progress = 0;
								this.direction = this.initDirection;
							}
							
						} else { // NOTE: This is timeline reverse --> not implemented
							this.timelinePos--;
							
							if(this.timelinePos < 0){
							
							this.activeTimeline = "";
							this.activeTimelineName = "";
							this.inTimeline = false;
							
							this.progress = 0;
							this.timelinePos = 0;
							this.timelineDelay = 0;
							
							this.unTick = true;
							//this._StopTicking();
							
							//timeline reverse finished triggers
							this.Trigger(C3.Behaviors.wackytoasterTweeen.Cnds.timelineReverseFinished);
							this.delay = 0;
							wi.SetBboxChanged();
							return;
							
							} else {
								setupTween(this, this.wTween[this.activeTimeline[this.timelinePos]], this.initDirection);
								setupToTween(this);
								this.progress = 1;
								this.direction = this.initDirection;
							}
						}
						
						
					} else {
						this.unTick = true;
						//this._StopTicking();
					
						//finished triggers
						if (this.initDirection === 0){
							this.Trigger(C3.Behaviors.wackytoasterTweeen.Cnds.tweenFinished);
							
							this.anyFinished = this.GetSdkType().GetBehaviorType().GetName();
							this.Trigger(C3.Behaviors.wackytoasterTweeen.Cnds.anyFinished);
							this.delay = 0;
							wi.SetBboxChanged();
							return;
						} else {
							this.Trigger(C3.Behaviors.wackytoasterTweeen.Cnds.reverseFinished);
							
							this.anyReverseFinished = this.GetSdkType().GetBehaviorType().GetName();
							this.Trigger(C3.Behaviors.wackytoasterTweeen.Cnds.anyReverseFinished);
							this.delay = 0;
							wi.SetBboxChanged();
							return;
						}
					}
				}
				
				//yoyo
				if (this.activeTween["yoyo"]){
					
					if (this.direction === 0){
						this.direction = 1;
					} else {
						this.direction = 0;
					}

				}			
				
				this.delay = 0;
				
			}
			
			wi.SetBboxChanged();
			
			
		}
		
	};
}