"use strict";

const tweens = ["linear", "easeInQuad", "easeOutQuad", "easeInOutQuad", "easeInCubic", "easeOutCubic", "easeInOutCubic", "easeInQuart", "easeOutQuart", "easeInOutQuart", "easeInQuint", "easeOutQuint", "easeInOutQuint", "easeInElastic", "easeOutElastic", "easeInOutElastic", "easeInBack", "easeOutBack", "easeInOutBack", "easeInBounce", "easeOutBounce", "easeInOutBounce"];

function trueFalse(tf){
	if (tf === 1){
		return true;
	}
	return false;
}

function indexToEase(i){
	return tweens[i];
}

function setupTween(bInst, tw, dir){
	
			bInst.unTick = false;
			bInst.postTick = 0;
	
			bInst.activeTween = tw;
			bInst.direction = dir;
			bInst.initDirection = dir;
			bInst.progress = dir;
			
			bInst.initialValues = 
			{
				"x": bInst.GetWorldInfo().GetX(),
				"y": bInst.GetWorldInfo().GetY(),
				"w": bInst.GetWorldInfo().GetWidth(),
				"h": bInst.GetWorldInfo().GetHeight(),
				"a": bInst.GetWorldInfo().GetAngle(),
				"o": bInst.GetWorldInfo().GetOpacity()
			}
			
		}
		
function setupToTween(bInst){
			
			//reset this.toTween
			bInst.toTween["x"] = true;
			bInst.toTween["y"] = true;
			bInst.toTween["w"] = true;
			bInst.toTween["h"] = true;
			bInst.toTween["a"] = true;
			bInst.toTween["o"] = true;
			
			//set this.toTween
			if (typeof bInst.activeTween["x"] === "string"){
				bInst.toTween["x"] = false;
			}
			if (typeof bInst.activeTween["y"] === "string"){
				bInst.toTween["y"] = false;
			}
			if (typeof bInst.activeTween["w"] === "string"){
				bInst.toTween["w"] = false;
			}
			if (typeof bInst.activeTween["h"] === "string"){
				bInst.toTween["h"] = false;
			}
			if (typeof bInst.activeTween["a"] === "string"){
				bInst.toTween["a"] = false;
			}
			if (typeof bInst.activeTween["o"] === "string"){
				bInst.toTween["o"] = false;
			}
			
		}

{
	C3.Behaviors.wackytoasterTweeen.Acts =
	{
		
		initializeTween(tweenID, ease, x, y, w, h, a, o, duration, repeat, yoyo, repeatDelay)
		{
			
			if (this.wTween[tweenID] !== undefined){
				console.warn("wTweeen: ", "Tween overridden --> " + tweenID);
			}
			
			this.wTween[tweenID] =
			{
				"ease": indexToEase(ease),
				"x": x,
				"y": y,
				"w": w,
				"h": h,
				"a": a,
				"o": o,
				"duration": duration,
				"repeat": repeat,
				"yoyo": trueFalse(yoyo),
				"repeatDelay": repeatDelay,
				"tweenID": tweenID
			}
			
		},
		
		startTween(tweenID, direction)
		{
			if(this.wTween[tweenID] === undefined){
				console.warn("wTweeen: ", "Tween " + tweenID + " not found, it has to be initialized first!");
				return;
			}
			
			setupTween(this, this.wTween[tweenID], direction);
			setupToTween(this);
			
			this._StartTicking();
		},
		
		pauseTween(){
			this._StopTicking();
		},
		
		resumeTween(){
			this._StartTicking();
		},
		
		initializeTimeline(timelineID, tl){
			/*tl = tl.replace(/'/g, '"');
			tl = JSON.parse(tl);*/
			this.wTimeline[timelineID] = tl;
		},
		
		startTimeline(timelineID, direction){
			if(this.wTimeline[timelineID] === undefined){
				console.warn("wTweeen: ", "Timeline " + timelineID + " not found, it has to be initialized first!");
				return;
			}
			
			direction = 0; //note: delete this to attempt to create reverse timelines
			
			//setting up for timeline finished trigger
			this.timelineFinished = timelineID;
			this.timelineReverseFinished = timelineID;
			
			this.inTimeline = true;
			this.activeTimeline = this.wTimeline[timelineID];
			
			if (direction === 0){
				this.timelinePos = 0;
			} else {
				this.timelinePos = this.activeTimeline.length - 1;
			}
			
			setupTween(this, this.wTween[this.activeTimeline[this.timelinePos]], direction);
			setupToTween(this);
			
			this.activeTimelineName = timelineID;
	
			this._StartTicking();
		},
		
		saveCurrState(stateID){
			const wi = this._inst.GetWorldInfo();
			
			this.wState[stateID] =
			{
				"x": wi.GetX(),
				"y": wi.GetY(),
				"w": wi.GetWidth(),
				"h": wi.GetHeight(),
				"a": C3.toDegrees(wi.GetAngle()),
				"o": wi.GetOpacity()
			}
			
		},
		
		saveParticularState(stateID, x, y, w, h, a, o){
			const wi = this._inst.GetWorldInfo();
			
			this.wState[stateID] =
			{
				"x": x,
				"y": y,
				"w": w,
				"h": h,
				"a": a,
				"o": o
			}
			
		},
		
		loadState(stateID){
			const wi = this._inst.GetWorldInfo();
			
			if (this.wState[stateID] === undefined){
				console.warn("State undefined, you have to save it first!");
				return;
			}
			
			if (typeof this.wState[stateID]["x"] !== "string") {wi.SetX(this.wState[stateID]["x"])};
			if (typeof this.wState[stateID]["y"] !== "string") {wi.SetY(this.wState[stateID]["y"])};
			if (typeof this.wState[stateID]["w"] !== "string") {wi.SetWidth(this.wState[stateID]["w"])};
			if (typeof this.wState[stateID]["h"] !== "string") {wi.SetHeight(this.wState[stateID]["h"])};
			if (typeof this.wState[stateID]["a"] !== "string") {wi.SetAngle(C3.toRadians(this.wState[stateID]["a"]))};
			if (typeof this.wState[stateID]["o"] !== "string") {wi.SetOpacity(this.wState[stateID]["o"])};
			
			wi.SetBboxChanged();
			
		}
	};
}