
const SDK = globalThis.SDK;

const PLUGIN_ID = "Rex_LayerObj";
const PLUGIN_CATEGORY = "other";

let app = null;

const PLUGIN_CLASS = SDK.Plugins.Rex_LayerObj = class Rex_LayerObj extends SDK.IPluginBase
{
	constructor()
	{
		super(PLUGIN_ID);
		
		SDK.Lang.PushContext("plugins." + PLUGIN_ID.toLowerCase());
		
		this._info.SetName(globalThis.lang(".name"));
		this._info.SetDescription(globalThis.lang(".description"));
		this._info.SetCategory(PLUGIN_CATEGORY);
		this._info.SetAuthor("Rex.Rainbow, Kashin Ginn");
		this._info.SetHelpUrl(globalThis.lang(".help-url"));
		this._info.SetPluginType("world");
		
		this._info.SetIsResizable(true);
		this._info.SetIsRotatable(true);
		
		this._info.SetHasImage(false);
		this._info.SetIsTiled(false);
		this._info.SetIsSingleGlobal(false);
		this._info.SetIsDeprecated(false);
		this._info.SetSupportsEffects(false);
		this._info.SetMustPreDraw(false);
		
		this._info.SetCanBeBundled(true);
		
		this._info.AddCommonPositionACEs();
		this._info.AddCommonSizeACEs();
		this._info.AddCommonAngleACEs();
		this._info.AddCommonAppearanceACEs();
		this._info.AddCommonZOrderACEs();

		this._info.SetRuntimeModuleMainScript("c3runtime/main.js");

		SDK.Lang.PushContext(".properties");
		
		this._info.SetProperties([
			new SDK.PluginProperty("check", "initially-visible", true)
		]);
		SDK.Lang.PopContext();		// .properties
		SDK.Lang.PopContext();
	}
};
PLUGIN_CLASS.Register(PLUGIN_ID, PLUGIN_CLASS);
