
const SDK = globalThis.SDK;

const PLUGIN_CLASS = SDK.Plugins.Rex_LayerObj;

PLUGIN_CLASS.Instance = class Rex_LayerObjInstance extends SDK.IWorldInstanceBase
{
	constructor(sdkType, inst)
	{
		super(sdkType, inst);
	}
	Release() {}
	OnCreate()
	{
		this._inst.SetOrigin(0.5, 0.5);
	}
	OnPlacedInLayout()
	{
		this._inst.SetSize(50, 50);
	}
	Draw(iRenderer, iDrawParams)
	{
		iRenderer.SetAlphaBlend();
		iRenderer.SetColorFillMode();
		iRenderer.SetColorRgba(1, 0.51, 0.48, 1); // rgb 255, 130, 122
		iRenderer.Quad(this._inst.GetQuad());
	}
	OnPropertyChanged(id, value)
	{
		this._inst.SetOrigin(0.5, 0.5);
	}
	LoadC2Property(name, valueString)
	{
		switch (name) {
			case "initial-visibility":
				return this._inst.SetPropertyValue("initially-visible", "Invisible" !== valueString),
				true;
		}
	}
};
