const C3 = globalThis.C3;

C3.Behaviors.lgshake.Instance = class lgshakeInstance extends globalThis.ISDKBehaviorInstanceBase
{
	constructor()
	{
		super();
		const properties = this._getInitProperties();
		
		this.shakeMag = 0;
		this.shakeStart = 0;
		this.shakeEnd = 0;
		this.shakeMode = 0;
		this.shakeEnforcePosition = 0;
		this.shakeOriginalX = 0;
		this.shakeOriginalY = 0;
		this.axis = 0;
		
		if (properties)
		{
			this.enabled = (properties[0] !== 0);
		}
		
		this._setTicking2(true);
	}
	
	_onCreate()
	{

	}

	_release()
	{
		this._setTicking2(false);
		super._release();
		
	}
	
	_saveToJson()
	{
		return {
			"smg": this.shakeMag,
			"ss": this.shakeStart,
			"se": this.shakeEnd,
			"smd": this.shakeMode,
			"enabled": this.enabled
		};
	}

	_loadFromJson(o)
	{
		this.shakeMag = o["smg"];
		this.shakeStart = o["ss"];
		this.shakeEnd = o["se"];
		this.shakeMode = o["smd"];
		if (o.hasOwnProperty("enabled"))
			this.enabled = o["enabled"];
	}
	
	_tick2()
	{
		
		const dt = this.runtime.dt;

		if (!this.enabled) {
			return;
		}
	
		// Is in a shake?
		var now = this.runtime.gameTime;
		var time = this.runtime.timeScale;

		var offx = 0, offy = 0;
		
		if (now >= this.shakeStart && now < this.shakeEnd)
		{
			var mag = this.shakeMag * Math.min(time, 1);
			
			// Mode 0 - reducing magnitude - lerp to zero
			if (this.shakeMode === 0){
				mag *= 1 - (now - this.shakeStart) / (this.shakeEnd - this.shakeStart);
			}
				
			var a = Math.random() * Math.PI * 2;
			var d = Math.random() * mag;
			offx = Math.cos(a) * d;
			offy = Math.sin(a) * d;
			

		}else {
        // The shake has ended, so we should stop ticking.
        // This is the key change.
        this._setTicking2(false);
        
        // We also need to reset the sprite's position if enforce position is on.
        if (this.shakeEnforcePosition) {
            this.instance.x = this.shakeOriginalX;
            this.instance.y = this.shakeOriginalY;
        }

        // Return immediately so no more code in _tick2() runs.
        return;
		}
		
	// Update only when necessary and one more time to enforce object position
	if (offx != 0 || offy != 0 || (this.shakeEnforcePosition === 1 && this.shakeStart > 0)) {
	
		if (this.instance) {
			if (this.axis == 1){
				this.instance.x = this.shakeEnforcePosition ? this.shakeOriginalX + offx : this.instance.x + offx;
			}
			else if (this.axis == 2){
				this.instance.y = this.shakeEnforcePosition ? this.shakeOriginalY + offy : this.instance.y + offy;
			}
			else{
				this.instance.x = this.shakeEnforcePosition ? this.shakeOriginalX + offx : this.instance.x + offx;
				this.instance.y = this.shakeEnforcePosition ? this.shakeOriginalY + offy : this.instance.y + offy;
			}
			if (typeof this.instance.setBboxChanged === 'function') {
				this.instance.setBboxChanged();
			} else {
			}
		} else {
		}
	}
	}
};