const SDK = globalThis.SDK;

const BEHAVIOR_ID = "lgshake";
const BEHAVIOR_CATEGORY = "general";

const BEHAVIOR_CLASS = SDK.Behaviors.lgshake = class lgshake extends SDK.IBehaviorBase
{
	constructor()
	{
		super(BEHAVIOR_ID);

		SDK.Lang.PushContext("behaviors." + BEHAVIOR_ID.toLowerCase());

		this._info.SetName(globalThis.lang(".name"));
		this._info.SetDescription(globalThis.lang(".description"));
		this._info.SetCategory(BEHAVIOR_CATEGORY);
		this._info.SetAuthor("Luiz Gama, Kashin Ginn");
		this._info.SetHelpUrl(globalThis.lang(".help-url"));
		this._info.SetIsOnlyOneAllowed(true);
		this._info.SetRuntimeModuleMainScript("c3runtime/main.js");

		SDK.Lang.PushContext(".properties");

		this._info.SetProperties([
			new SDK.PluginProperty("combo", "initial-state", {initialValue:"enabled", items:["disabled","enabled"]})
		]);
		
		SDK.Lang.PopContext();	// .properties
		
		SDK.Lang.PopContext();
	}
};

BEHAVIOR_CLASS.Register(BEHAVIOR_ID, BEHAVIOR_CLASS);