const SDK = globalThis.SDK;
const PLUGIN_ID = "EMI_INDO_DocumentFile";
const PLUGIN_CATEGORY = "data-and-storage";
const PLUGIN_CLASS = SDK.Plugins.EMI_INDO_DocumentFile = class EMI_INDO_DocumentFile extends SDK.IPluginBase {
    constructor() {
        super(PLUGIN_ID);
        SDK.Lang.PushContext("plugins." + PLUGIN_ID.toLowerCase());
        this._info.SetName(globalThis.lang(".name"));
        this._info.SetDescription(globalThis.lang(".description"));
        this._info.SetCategory(PLUGIN_CATEGORY);
        this._info.SetAuthor("EMI_INDO");
        this._info.SetHelpUrl(globalThis.lang(".help-url"));
        this._info.SetIsSingleGlobal(true);
        this._info.SetRuntimeModuleMainScript("c3runtime/main.js");
        const CAMERA = new SDK.PluginProperty("text", "IS-CAMERA-PERMISSION", "false");
        const VIDEO = new SDK.PluginProperty("text", "IS-READ-M-VIDEO-PERMISSION", "false");
        const IMAGES = new SDK.PluginProperty("text", "IS-READ-M-IMAGES-PERMISSION", "false");
        const MANAGE_STORAGE = new SDK.PluginProperty("text", "IS-MANAGE-STORAGE-PERMISSION", "false");
        SDK.Lang.PushContext(".properties");
        this._info.SetProperties([
            new SDK.PluginProperty("group", "enable-permissions"),
            CAMERA,
            VIDEO,
            IMAGES,
            MANAGE_STORAGE
        ]);
        this._info.AddCordovaPluginReference({
            id: "cordova-plugin-save-blob",
            version: "0.0.3",
            platform: "android",
            plugin: this,
            variables: [
                ["IS_CAMERA_PERMISSION", CAMERA],
                ["IS_READ_M_VIDEO_PERMISSION", VIDEO],
                ["IS_READ_M_IMAGES_PERMISSION", IMAGES],
                ["IS_MANAGE_STORAGE_PERMISSION", MANAGE_STORAGE]
            ]
        });
        this._info.AddCordovaPluginReference({ id: "cordova-plugin-android-permissions" });
        SDK.Lang.PopContext();
        SDK.Lang.PopContext();
    }
};
PLUGIN_CLASS.Register(PLUGIN_ID, PLUGIN_CLASS);
