const C3 = globalThis.C3;
class EMI_INDO_DocumentFileInstance extends globalThis.ISDKInstanceBase {
    constructor() {
        super();
        const properties = this._getInitProperties();
        if (properties) {
        }
        this._isCordovaReady = false;
        if (typeof globalThis.cordova !== 'undefined') {
            this._isCordovaReady = true;
        }
        this._Tags = "";
        this._errorTag = null;
        this._errorMessage = "";
        this._name = "";
        this._mimeType = "";
        this._base64 = "";
        this._uriFilesSAF = "";
        this._uriTraditionalPath = "";
        this._size = "";
        this._sizeReadable = "";
        this._mb = 0;
        this._fileExtension = "";
        this._nameDu = "";
        this._mimeTypeDu = "";
        this._base64Du = "";
        this._uriFilesSAFDu = "";
        this._uriTraditionalPathDu = "";
        this._sizeDu = "";
        this._sizeReadableDu = "";
        this._mbDu = 0;
        this._uriTargetPath = "";
        this._uriTargetTraditionalPath = "";
        this._convertTraditionalPath = "";
        this._isCamera = false;
        this._readMediaAudio = false;
        this._isReadMediaVideo = false;
        this._isReadMediaImages = false;
        this._readExternalStorage = false;
        this._writeExternalStorage = false;
        this._recordAudio = false;
        this._modifyAudioSetting = false;
        this._IsManageExternalStorage = false;
        this._statusProgress = 0;
        this._statusType = null;
        this._downloadSaveFilesToSAF = "";
    }
    _release() {
        super._release();
    }
    _setTestProperty(n) {
    }
    _getTestProperty() {
    }
    _saveToJson() {
        return {};
    }
    _loadFromJson(o) {
    }
    _CheckAndRequestPermissions(isCamera, isReadMediaAudio, isReadMediaVideo, isReadMediaImages, isReadExternalStorage, isWriteExternalStorage, isRecordAudio, isModifyAudioSetting, IsManageExternalStorage, tag) {
        if (this._isCordovaReady) {
            var permissions = globalThis.cordova.plugins.permissions;
            let permissionsData = [];
            if (isCamera) {
                permissions.requestPermission(permissions.CAMERA);
            }
            if (isReadMediaAudio) {
                permissionsData.push("READ_MEDIA_AUDIO");
            }
            if (isReadMediaVideo) {
                permissionsData.push("READ_MEDIA_VIDEO");
            }
            if (isReadMediaImages) {
                permissionsData.push("READ_MEDIA_IMAGES");
            }
            if (isReadExternalStorage) {
                permissionsData.push("READ_EXTERNAL_STORAGE");
            }
            if (isWriteExternalStorage) {
                permissionsData.push("WRITE_EXTERNAL_STORAGE");
            }
            if (isRecordAudio) {
                permissionsData.push("RECORD_AUDIO");
            }
            if (isModifyAudioSetting) {
                permissionsData.push("MODIFY_AUDIO_SETTINGS");
            }
            if (IsManageExternalStorage) {
                permissions.requestPermission(permissions.MANAGE_EXTERNAL_STORAGE);
            }
            const self = this;
            globalThis.cordova.plugin.CordovaSaveBlob.checkAndRequestPermissions({
                permissions: permissionsData
            }, (result) => {
                self._Tags = tag;
                self._isCamera = !!result["android.permission.CAMERA"];
                self._readMediaAudio = !!result["android.permission.READ_MEDIA_AUDIO"];
                self._isReadMediaVideo = !!result["android.permission.READ_MEDIA_VIDEO"];
                self._isReadMediaImages = !!result["android.permission.READ_MEDIA_IMAGES"];
                self._readExternalStorage = !!result["android.permission.READ_EXTERNAL_STORAGE"];
                self._writeExternalStorage = !!result["android.permission.WRITE_EXTERNAL_STORAGE"];
                self._recordAudio = !!result["android.permission.RECORD_AUDIO"];
                self._modifyAudioSetting = !!result["android.permission.MODIFY_AUDIO_SETTINGS"];
                self._IsManageExternalStorage = !!result["android.permission.MANAGE_EXTERNAL_STORAGE"];
                self._trigger(C3.Plugins.EMI_INDO_DocumentFile.Cnds.OnTag);
                self._trigger(C3.Plugins.EMI_INDO_DocumentFile.Cnds.IsTag);
            }, (err) => {
                self._errorTag = 0;
                self._errorMessage = `${err}`;
                self._trigger(C3.Plugins.EMI_INDO_DocumentFile.Cnds.OnError);
            });
        }
    }
    parseAndRoundSize(sizeString) {
        const parts = sizeString.split(' ');
        const value = parseFloat(parts[0]);
        const unit = parts[1].toUpperCase();
        let valueInMB;
        if (unit === 'KB') {
            valueInMB = value / 1024;
        }
        else if (unit === 'MB') {
            valueInMB = value;
        }
        else {
            return 0;
        }
        if (unit === 'KB' && valueInMB < 1) {
            return 1;
        }
        else {
            return Math.floor(valueInMB);
        }
    }
    _SelectFile(mime, isBase64, tag) {
        if (this._isCordovaReady) {
            const self = this;
            globalThis.cordova.plugin.CordovaSaveBlob.selectFiles({
                mime: mime,
                isBase64: isBase64
            }, function (response) {
                self._Tags = tag;
                self._name = response.name.substring(0, response.name.lastIndexOf('.'));
                self._fileExtension = response.name.substring(response.name.lastIndexOf('.') + 1).toLowerCase();
                self._mimeType = response.mimeType;
                self._base64 = response.base64;
                self._uriFilesSAF = response.uri;
                self._uriTraditionalPath = response.traditionalPath;
                self._size = response.size;
                self._sizeReadable = response.sizeReadable;
                self._mb = self.parseAndRoundSize(response.sizeReadable);
                self._trigger(C3.Plugins.EMI_INDO_DocumentFile.Cnds.OnTag);
                self._trigger(C3.Plugins.EMI_INDO_DocumentFile.Cnds.IsTag);
            }, function (error) {
                self._errorTag = 1;
                self._errorMessage = `${error}`;
                self._trigger(C3.Plugins.EMI_INDO_DocumentFile.Cnds.OnError);
            });
        }
    }
    _SelectTargetPath(tag) {
        if (this._isCordovaReady) {
            const self = this;
            globalThis.cordova.plugin.CordovaSaveBlob.selectTargetPath(function (response) {
                self._Tags = tag;
                self._uriTargetPath = response.uri;
                self._uriTargetTraditionalPath = response.traditionalPath;
                self._trigger(C3.Plugins.EMI_INDO_DocumentFile.Cnds.OnTag);
                self._trigger(C3.Plugins.EMI_INDO_DocumentFile.Cnds.IsTag);
            }, function (error) {
                self._errorTag = 2;
                self._errorMessage = `${error}`;
                self._trigger(C3.Plugins.EMI_INDO_DocumentFile.Cnds.OnError);
            });
        }
    }
    _RegisterWebRtc() {
        if (this._isCordovaReady) {
            globalThis.cordova.plugin.CordovaSaveBlob.registerWebRTC();
        }
    }
    _ConvertPathSafToTraditional(uriSaf, tag) {
        if (this._isCordovaReady) {
            const self = this;
            globalThis.cordova.plugin.CordovaSaveBlob.conversionSAFUri({ uriPath: uriSaf }, function (response) {
                self._Tags = tag;
                self._convertTraditionalPath = response;
                self._trigger(C3.Plugins.EMI_INDO_DocumentFile.Cnds.OnTag);
                self._trigger(C3.Plugins.EMI_INDO_DocumentFile.Cnds.IsTag);
            }, function (error) {
                self._errorTag = 3;
                self._errorMessage = `${error}`;
                self._trigger(C3.Plugins.EMI_INDO_DocumentFile.Cnds.OnError);
            });
        }
    }
    _OpenAppSettings() {
        if (this._isCordovaReady) {
            globalThis.cordova.plugin.CordovaSaveBlob.openAppSettings();
        }
    }
    _DownloadBlob(saveToPath, base64Data, fileName, isSaveCreateBase64, tag) {
        if (this._isCordovaReady) {
            const self = this;
            const base64 = base64Data.replace(/^data:.*;base64,/, '');
            globalThis.cordova.plugin.CordovaSaveBlob.downloadBlob({
                saveToPath: saveToPath,
                base64Data: base64,
                fileName: fileName,
                isBase64: isSaveCreateBase64
            }, function (response) {
                self._Tags = tag;
                self._nameDu = response.name.substring(0, response.name.lastIndexOf('.'));
                self._mimeTypeDu = response.mimeType;
                self._base64Du = response.base64;
                self._uriFilesSAFDu = response.uri;
                self._uriTraditionalPathDu = response.traditionalPath;
                self._sizeDu = response.size;
                self._sizeReadableDu = response.sizeReadable;
                self._mbDu = self.parseAndRoundSize(response.sizeReadable);
                self._trigger(C3.Plugins.EMI_INDO_DocumentFile.Cnds.OnTag);
                self._trigger(C3.Plugins.EMI_INDO_DocumentFile.Cnds.IsTag);
            }, function (error) {
                self._errorTag = 4;
                self._errorMessage = `${error}`;
                self._trigger(C3.Plugins.EMI_INDO_DocumentFile.Cnds.OnError);
            });
        }
    }
    _DownloadFileFromUrl(fileUrl, isBase64, saveToPath, fileName, tag) {
        if (this._isCordovaReady) {
            const self = this;
            globalThis.cordova.plugin.CordovaSaveBlob.downloadFile({
                fileUrl: fileUrl,
                isBase64: isBase64,
                saveToPath: saveToPath,
                fileName: fileName
            }, function (response) {
                if (typeof response === "number") {
                    self._Tags = tag;
                    self._statusType = 0;
                    self._statusProgress = response + "%";
                    self._trigger(C3.Plugins.EMI_INDO_DocumentFile.Cnds.OnProgress);
                }
                else {
                    self._Tags = tag;
                    self._statusType = 1;
                    self._nameDu = response.name.substring(0, response.name.lastIndexOf('.'));
                    self._mimeTypeDu = response.mimeType;
                    self._base64Du = response.base64;
                    self._uriFilesSAFDu = response.uri;
                    self._uriTraditionalPathDu = response.traditionalPath;
                    self._downloadSaveFilesToSAF = response.traditionalPath;
                    self._sizeDu = response.size;
                    self._sizeReadableDu = response.sizeReadable;
                    self._mbDu = self.parseAndRoundSize(response.sizeReadable);
                    self._trigger(C3.Plugins.EMI_INDO_DocumentFile.Cnds.OnProgress);
                }
                self._trigger(C3.Plugins.EMI_INDO_DocumentFile.Cnds.OnTag);
            }, function (error) {
                self._errorTag = 5;
                self._errorMessage = `${error}`;
                self._trigger(C3.Plugins.EMI_INDO_DocumentFile.Cnds.OnError);
            });
        }
    }
    _FileToBase64(filePath, tag) {
        if (this._isCordovaReady) {
            const self = this;
            globalThis.cordova.plugin.CordovaSaveBlob.fileToBase64({
                filePath: filePath
            }, function (response) {
                self._Tags = tag;
                self._base64 = response.base64;
                self._trigger(C3.Plugins.EMI_INDO_DocumentFile.Cnds.OnTag);
                self._trigger(C3.Plugins.EMI_INDO_DocumentFile.Cnds.IsTag);
            }, function (error) {
                self._errorTag = 6;
                self._errorMessage = `${error}`;
                self._trigger(C3.Plugins.EMI_INDO_DocumentFile.Cnds.OnError);
            });
        }
    }
    _Base64SrcElementId(elmId, mimeType, base64, tag) {
        const self = this;
        const elm = document.getElementById(elmId);
        if (!elm) {
            console.error(`Element with ID '${elmId}' not found.`);
            self._errorTag = 7;
            self._errorMessage = (`Element with ID '${elmId}' not found.`);
            self._trigger(C3.Plugins.EMI_INDO_DocumentFile.Cnds.OnError);
            return;
        }
        if (!('src' in elm)) {
            console.error(`Element with ID '${elmId}' does not have a 'src' attribute.`);
            self._errorTag = 7;
            self._errorMessage = (`Element with ID '${elmId}' does not have a 'src' attribute.`);
            self._trigger(C3.Plugins.EMI_INDO_DocumentFile.Cnds.OnError);
            return;
        }
        self._Tags = tag;
        const base64String = `data:${mimeType};base64,${base64}`;
        self._trigger(C3.Plugins.EMI_INDO_DocumentFile.Cnds.OnTag);
        self._trigger(C3.Plugins.EMI_INDO_DocumentFile.Cnds.IsTag);
        elm.src = base64String;
    }
}
;
C3.Plugins.EMI_INDO_DocumentFile.Instance = EMI_INDO_DocumentFileInstance;
