
const C3 = globalThis.C3;

C3.Behaviors.FedericoCalchera_animatedTile.Instance = class animatedTile extends globalThis.ISDKBehaviorInstanceBase {
	constructor() {
		super();
		this._tileSequence = [];
		this._fps = 0;
		this._lastUpdate = 0;
		this._isEnabled = true

		const properties = this._getInitProperties();
		if (properties) {

			this._tileSequence = this.getTileSequenceFromString(properties[0]);
			this._fps = properties[1];
			this.isEnabled = properties[2]
		}

	}

	_release() {
		super._release();
	}

	getTileSequenceFromString(string) {
		return string.split(" ").map(Number);
	}

	setTileSequenceFromArray(arr) {
		this._tileSequence = arr;
	}

	set fps(value) {
		this._fps = value;
	}

	get fps() {
		return this._fps;
	}

	set isEnabled(value) {
		this._isEnabled = value;
		this._setTicking(value);
		
	}

	get isEnabled() {
		return this._isEnabled;
	}

	_saveToJson() {
		return {
			"fps": this._fps,
			"tileSequence": this._tileSequence,
			"isEnabled": this.isEnabled
		};
	}

	_loadFromJson(o) {
		this._fps = o.fps;
		this._tileSequence = o.tileSequence;
		this.isEnabled = o.isEnabled;
	}

	_tick() {
		const tilemap = this.instance;
		this._lastUpdate += this.instance.dt;
		const frameIndex = Math.floor(this._lastUpdate * this._fps) % this._tileSequence.length;
		const animTile = this._tileSequence[frameIndex];

		const viewport = tilemap.layer.getViewport();
		const xOffset = Math.ceil(viewport.x - tilemap.x) / tilemap.tileWidth;
		const yOffset = Math.ceil(viewport.y - tilemap.y) / tilemap.tileHeight;
		const visibleWidth = Math.ceil(viewport.width / tilemap.tileWidth) + xOffset + 1;
		const visibleHeight = Math.ceil(viewport.height / tilemap.tileHeight) + yOffset + 1;
		
		for (let x = xOffset; x < visibleWidth; x++) {
			for (let y = yOffset; y < visibleHeight; y++) {

				const tileID = tilemap.getTileAt(x, y);
				if (tileID === -1) continue;

				const flags = tileID & 0xE0000000;
				if (this._tileSequence.includes(tileID & this.instance.TILE_ID_MASK)) {
					tilemap.setTileAt(x, y, animTile | flags)
				}
			}
		}
	}
};
