
const C3 = globalThis.C3;

C3.Behaviors.FedericoCalchera_animatedTile.Instance = class animatedTile extends globalThis.ISDKBehaviorInstanceBase {
	constructor() {
		super();

		this._tileSequence = [];
		this._fps = 0;
		this._lastUpdate = 0;

		const properties = this._getInitProperties();
		if (properties) {

			this._tileSequence = this.getTileSequenceFromString(properties[0]);
			this._fps = properties[1];
		}

		this._setTicking(true);
	}

	_release() {
		super._release();
	}

	getTileSequenceFromString(string) {
		return string.split(" ").map(Number);
	}

	setTileSequenceFromArray(arr) {
		this._tileSequence = arr;
	}

	set fps(value) {
		this._fps = value;
	}

	get fps() {
		return this._fps;
	}

	_saveToJson() {
		return {
			"fps": this._fps,
			"tileSequence": this._tileSequence
		};
	}

	_loadFromJson(o) {
		this._fps = o.fps;
		this._tileSequence = o.tileSequence
	}

	_tick() {
		const dt = this.instance.dt;
		const tilemap = this.instance;
		this._lastUpdate += dt;
		const frameIndex = Math.floor(this._lastUpdate * this._fps) % this._tileSequence.length;
		const animTile = this._tileSequence[frameIndex];

		const viewport = tilemap.layer.getViewport();
		const xOffset = Math.ceil(viewport.x - tilemap.x) / tilemap.tileWidth;
		const yOffset = Math.ceil(viewport.y - tilemap.y) / tilemap.tileHeight;
		const visibleWidth = Math.ceil(viewport.width / tilemap.tileWidth) + xOffset + 1;
		const visibleHeight = Math.ceil(viewport.height / tilemap.tileHeight) + yOffset + 1;
		for (let x = xOffset; x < visibleWidth; x++) {
			for (let y = yOffset; y < visibleHeight; y++) {
				if (this._tileSequence.includes(tilemap.getTileAt(x, y))) {
					tilemap.setTileAt(x, y, animTile)
				}
			}
		}
	}
};
